/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.System;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.tracer.monitor.StackEntity;
import org.springframework.util.StringUtils;

public class ExecCmd {
    public static String execute(String[] cmd, String ... encoding) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedInputStream bis = new BufferedInputStream(p.getInputStream());
            InputStreamReader inputStreamReader = encoding != null && encoding.length != 0 ? new InputStreamReader((InputStream)bis, encoding[0]) : new InputStreamReader((InputStream)bis, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            bufferedReader.close();
            inputStreamReader.close();
            p.destroy();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = null;
        try {
            ip = request.getHeader("x-forwarded-for");
            if (StringUtils.isEmpty((Object)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((Object)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isEmpty((Object)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StringUtils.isEmpty((Object)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            Logger.error((String)"IPUtils ERROR ", (Object[])new Object[]{e});
        }
        return ip;
    }

    public static String getHostIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "127.0.0.1";
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "\u672a\u77e5";
        }
    }

    public static String version() {
        try {
            String line;
            Process p = Runtime.getRuntime().exec(new String[]{"java", "-version"});
            InputStreamReader inputStreamReader = new InputStreamReader(p.getErrorStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            bufferedReader.close();
            p.destroy();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getRootPath() {
        return ExecCmd.rootPath("");
    }

    public static String getRootPath(String path) {
        return ExecCmd.rootPath("/" + path);
    }

    public static String exJmap() {
        String id = ExecCmd.getPid();
        String path = ExecCmd.getRootPath("dump/" + id + "_heap.hprof");
        File file = new File(ExecCmd.getRootPath("dump/"));
        if (!file.exists()) {
            file.mkdirs();
        }
        ExecCmd.execute(new String[]{"jmap", "-dump:format=b,file=" + path, id}, new String[0]);
        return path;
    }

    public static String exJstack() {
        String id = ExecCmd.getPid();
        String path = ExecCmd.getRootPath("dump/" + id + "_thread.txt");
        String s = ExecCmd.execute(new String[]{"jstack", id}, new String[0]);
        File file = new File(path);
        FileKit.writeString((String)s, (File)file, (java.nio.charset.Charset)Charset.UTF_8);
        return path;
    }

    public static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.split("@")[0];
        return pid;
    }

    public static StackEntity jstack() {
        String id = ExecCmd.getPid();
        String s = ExecCmd.execute(new String[]{"jstack", id}, new String[0]);
        int total = ExecCmd.appearNumber(s, "nid=");
        String prefix = "java.lang.Thread.State: ";
        int RUNNABLE = ExecCmd.appearNumber(s, prefix + "RUNNABLE");
        int TIMED_WAITING = ExecCmd.appearNumber(s, prefix + "TIMED_WAITING");
        int WAITING = ExecCmd.appearNumber(s, prefix + "WAITING");
        return new StackEntity(id, total, RUNNABLE, TIMED_WAITING, WAITING);
    }

    public static int appearNumber(String srcText, String findText) {
        int count = 0;
        Pattern p = Pattern.compile(findText);
        Matcher m = p.matcher(srcText);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static List<Map<String, String>> jstatClazz() throws IOException {
        String id = ExecCmd.getPid();
        List<Map<String, String>> jstatClass = ExecCmd.jstat(new String[]{"jstat", "-class", id});
        List<Map<String, String>> jstatCompiler = ExecCmd.jstat(new String[]{"jstat", "-compiler", id});
        jstatClass.addAll(jstatCompiler);
        return jstatClass;
    }

    public static List<Map<String, String>> jstatGc() throws IOException {
        return ExecCmd.jstat(new String[]{"jstat", "-gc", ExecCmd.getPid()});
    }

    public static List<Map<String, String>> jstatUtil() throws IOException {
        return ExecCmd.jstat(new String[]{"jstat", "-gcutil", ExecCmd.getPid()});
    }

    private static String rootPath(String path) {
        String rootPath = "";
        String classPath = System.getProperty((String)"user.dir");
        if ("\\".equals(File.separator)) {
            rootPath = classPath + path;
            if ((rootPath = rootPath.replaceAll("/", "\\\\")).startsWith("\\")) {
                rootPath = rootPath.substring(1);
            }
        }
        if ("/".equals(File.separator)) {
            rootPath = classPath + path;
            rootPath = rootPath.replaceAll("\\\\", "/");
        }
        return rootPath;
    }

    private static List<Map<String, String>> jstat(String[] strings) throws IOException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String s = ExecCmd.execute(strings, new String[0]);
        assert (s != null);
        BufferedReader reader = new BufferedReader(new StringReader(s));
        String[] keys = ArrayKit.toStringArray((Object[])reader.readLine().split("\\s+|\t"));
        String[] values = ArrayKit.toStringArray((Object[])reader.readLine().split("\\s+|\t"));
        if (strings[1].equals("-compiler")) {
            for (int i = 0; i < 4; ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(keys[i], values[i]);
                list.add(map);
            }
            return list;
        }
        for (int i = 0; i < keys.length; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(keys[i], values[i]);
            list.add(map);
        }
        return list;
    }
}

