/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.Tracer;
import org.aoju.bus.tracer.config.TraceFilterConfig;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;

@WebListener(value="TraceServletRequestListener to read incoming TPICs into Builder backend")
public final class TraceServletRequestListener
implements ServletRequestListener {
    private static final String HTTP_HEADER_NAME = "TPIC";
    private final Backend backend;
    private final HttpHeaderTransport transportSerialization;

    protected TraceServletRequestListener(Backend backend, HttpHeaderTransport transportSerialization) {
        this.backend = backend;
        this.transportSerialization = transportSerialization;
    }

    public TraceServletRequestListener() {
        this(Tracer.getBackend(), new HttpHeaderTransport());
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        this.backend.clear();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        ServletRequest servletRequest = sre.getServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            this.httpRequestInitialized((HttpServletRequest)servletRequest);
        }
    }

    private void httpRequestInitialized(HttpServletRequest request) {
        Enumeration headers;
        TraceFilterConfig configuration = this.backend.getConfiguration();
        if (configuration.shouldProcessContext(TraceFilterConfig.Channel.IncomingRequest) && (headers = request.getHeaders(HTTP_HEADER_NAME)) != null && headers.hasMoreElements()) {
            Map<String, String> contextMap = this.transportSerialization.parse(Collections.list(headers));
            this.backend.putAll(this.backend.getConfiguration().filterDeniedParams(contextMap, TraceFilterConfig.Channel.IncomingRequest));
        }
        Builder.generateInvocationIdIfNecessary(this.backend);
        HttpSession session = request.getSession(false);
        if (session != null) {
            Builder.generateSessionIdIfNecessary(this.backend, session.getId());
        }
    }
}

