/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer;

import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.xml.namespace.QName;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.tracer.Backend;

public final class Builder {
    public static final String TRACE_PROPERTIES_FILE = "/tracer.properties";
    public static final String TRACE_DEFAULT_PROPERTIES_FILE = "META-INF/tracer/tracer.default.properties";
    public static final String TPIC_HEADER = "TPIC";
    public static final String SOAP_HEADER_NAMESPACE = "https://www.aoju.org/tpic/1.0";
    public static final QName SOAP_HEADER_QNAME = new QName("https://www.aoju.org/tpic/1.0", "TPIC");
    public static final String SESSION_ID_KEY = "TPIC.sessionId";
    public static final String INVOCATION_ID_KEY = "TPIC.invocationId";
    public static final char[] ALPHANUMERICS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    public static final String DEFAULT = "default";
    public static final String HIDE_INBOUND = "HideInbound";
    public static final String HIDE_OUTBOUND = "HideOutbound";
    public static final String DISABLE_INBOUND = "DisableInbound";
    public static final String DISABLE_OUTBOUND = "DisableOutbound";
    public static final String DISABLED = "Disabled";

    public static String createRandomAlphanumeric(int length) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        char[] randomChars = new char[length];
        for (int i = 0; i < length; ++i) {
            randomChars[i] = ALPHANUMERICS[((Random)r).nextInt(ALPHANUMERICS.length)];
        }
        return new String(randomChars);
    }

    public static String createAlphanumericHash(String str, int length) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(str.getBytes(Charset.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                if (b < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(b & 0xFF));
            }
            while (sb.length() < length) {
                sb.append(sb.toString());
            }
            return sb.delete(length, sb.length()).toString();
        }
        catch (UnsupportedCharsetException | NoSuchAlgorithmException e) {
            return Builder.createRandomAlphanumeric(length);
        }
    }

    public static void generateInvocationIdIfNecessary(Backend backend) {
        if (null != backend && !backend.containsKey(INVOCATION_ID_KEY) && backend.getConfiguration().shouldGenerateInvocationId()) {
            backend.put(INVOCATION_ID_KEY, Builder.createRandomAlphanumeric(backend.getConfiguration().generatedInvocationIdLength()));
        }
    }

    public static void generateSessionIdIfNecessary(Backend backend, String sessionId) {
        if (null != backend && !backend.containsKey(SESSION_ID_KEY) && backend.getConfiguration().shouldGenerateSessionId()) {
            backend.put(SESSION_ID_KEY, Builder.createAlphanumericHash(sessionId, backend.getConfiguration().generatedSessionIdLength()));
        }
    }
}

