/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer;

import java.lang.ref.SoftReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aoju.bus.tracer.backend.TraceBackendProvider;

public class Provider
extends AbstractSet<TraceBackendProvider> {
    private Set<SoftReference<TraceBackendProvider>> values = new HashSet<SoftReference<TraceBackendProvider>>();
    private boolean valid = true;

    Provider(Set<TraceBackendProvider> elements) {
        this.addAllInternal(elements);
    }

    @Override
    public Iterator<TraceBackendProvider> iterator() {
        Collection<TraceBackendProvider> strongRefList = this.createStrongView(this.values);
        this.determineValidity(strongRefList);
        if (this.valid) {
            return strongRefList.iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public int size() {
        Collection<TraceBackendProvider> strongRefList = this.createStrongView(this.values);
        this.determineValidity(strongRefList);
        if (this.valid) {
            return strongRefList.size();
        }
        return 0;
    }

    private void addAllInternal(Collection<TraceBackendProvider> elements) {
        for (TraceBackendProvider element : elements) {
            this.values.add(new SoftReference<TraceBackendProvider>(element));
        }
    }

    private void determineValidity(Collection<TraceBackendProvider> providers) {
        if (!this.valid) {
            return;
        }
        for (TraceBackendProvider provider : providers) {
            if (null != provider) continue;
            this.valid = false;
        }
    }

    private Collection<TraceBackendProvider> createStrongView(Collection<SoftReference<TraceBackendProvider>> providerReferences) {
        ArrayList<TraceBackendProvider> strongRefs = new ArrayList<TraceBackendProvider>(providerReferences.size());
        for (SoftReference<TraceBackendProvider> providerSoftReference : providerReferences) {
            strongRefs.add(providerSoftReference.get());
        }
        return strongRefs;
    }
}

