/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.servlet;

import java.io.IOException;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Tracer;
import org.aoju.bus.tracer.config.TraceFilterConfig;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;

@WebFilter(filterName="TraceFilter", urlPatterns={"/*"}, dispatcherTypes={DispatcherType.REQUEST})
public class TraceFilter
implements Filter {
    public static final String PROFILE_INIT_PARAM = "profile";
    private static final String HTTP_HEADER_NAME = "TPIC";
    private final Backend backend;
    private final HttpHeaderTransport transportSerialization;
    private String profile = "default";

    public TraceFilter() {
        this(Tracer.getBackend(), new HttpHeaderTransport());
    }

    TraceFilter(Backend backend, HttpHeaderTransport transportSerialization) {
        this.backend = backend;
        this.transportSerialization = transportSerialization;
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            this.doFilterHttp((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        TraceFilterConfig configuration = this.backend.getConfiguration(this.profile);
        try {
            this.writeContextToResponse(response, configuration);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!response.isCommitted()) {
                this.writeContextToResponse(response, configuration);
            }
        }
    }

    private void writeContextToResponse(HttpServletResponse response, TraceFilterConfig configuration) {
        if (!this.backend.isEmpty() && configuration.shouldProcessContext(TraceFilterConfig.Channel.OutgoingResponse)) {
            Map<String, String> filteredContext = this.backend.getConfiguration(this.profile).filterDeniedParams(this.backend.copyToMap(), TraceFilterConfig.Channel.OutgoingResponse);
            response.setHeader(HTTP_HEADER_NAME, this.transportSerialization.render(filteredContext));
        }
    }

    public final void init(FilterConfig filterConfig) {
        String profileInitParameter = filterConfig.getInitParameter(PROFILE_INIT_PARAM);
        if (null != profileInitParameter) {
            this.profile = profileInitParameter;
        }
    }

    public final void destroy() {
    }
}

