/*
 * Decompiled with CFR 0.152.
 */
package org.aooshi.j;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsistentHashing<T> {
    private static final Logger log = LoggerFactory.getLogger(ConsistentHashing.class);
    private SortedMap<Integer, T> nodeMap = new TreeMap<Integer, T>();
    private T[] nodes;
    private Integer virtualNumber = 5;

    public ConsistentHashing(T[] nodes) {
        this.nodes = nodes;
        this.reset(nodes);
    }

    public void reset(T[] nodes) {
        TreeMap<Integer, T> nodeMap = new TreeMap<Integer, T>();
        for (T node : nodes) {
            for (int i = 0; i < this.virtualNumber; ++i) {
                String n = i + "&&" + node.toString();
                int code = this.getCode(n);
                nodeMap.put(code, node);
            }
        }
        this.nodeMap = nodeMap;
    }

    public T getNode(String key) {
        int code = this.getCode(key);
        return this.getNode(code);
    }

    public T getNode(Integer code) {
        SortedMap<Integer, T> nodeMap = this.nodeMap;
        if (nodeMap.size() == 0) {
            return null;
        }
        SortedMap<Integer, T> sortedMap = nodeMap.tailMap(code);
        code = sortedMap.isEmpty() ? nodeMap.lastKey() : sortedMap.firstKey();
        return (T)sortedMap.get(code);
    }

    private int getCode(String value) {
        if (value == null) {
            return 0;
        }
        int p = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < value.length(); ++i) {
            hash = (hash ^ value.charAt(i)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        if ((hash += hash << 5) < 0) {
            hash = Math.abs(hash);
        }
        return hash;
    }

    public Map<Integer, T> getNodeMaps() {
        return this.nodeMap;
    }

    public void printNodes() {
        log.info(this.getClass().getSimpleName() + " -- nodes");
        for (T node : this.nodes) {
            log.info(node.toString());
        }
        log.info(this.getClass().getSimpleName() + " -- node maps");
        this.nodeMap.forEach((k, v) -> log.info(k + " : " + v));
    }

    public T[] getNodes() {
        return this.nodes;
    }

    public Integer getVirtualNumber() {
        return this.virtualNumber;
    }

    public void setVirtualNumber(Integer virtualNumber) {
        this.virtualNumber = virtualNumber;
    }
}

