/*
 * Decompiled with CFR 0.152.
 */
package org.aooshi.j;

import org.aooshi.j.HashRedisConfigItem;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class HashRedisWorker
extends JedisPool {
    private static int timeout = 5000;
    private static int max_active = 1024;
    private static int max_idle = 200;
    private static int max_wait = 10000;
    private static boolean test_on_borrow = true;
    private HashRedisConfigItem configItem;

    public HashRedisWorker(HashRedisConfigItem configItem) {
        super((GenericObjectPoolConfig)HashRedisWorker.createPoolConfig(), configItem.getHost(), configItem.getPort().intValue(), timeout, configItem.getPassword(), configItem.getDatabase().intValue());
        this.configItem = configItem;
    }

    private static JedisPoolConfig createPoolConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(max_idle);
        config.setMaxWaitMillis((long)max_wait);
        config.setTestOnBorrow(test_on_borrow);
        config.setMaxTotal(max_active);
        return config;
    }

    public String toString() {
        String host = this.configItem.getHost();
        int port = this.configItem.getPort();
        int database = this.configItem.getDatabase();
        return String.format("redis://%s:%d/%d", host, port, database);
    }
}

