/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import io.apicurio.registry.client.CompatibleClient;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.VersionMetaData;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.strategy.DefaultIdHandler;
import io.apicurio.registry.utils.serde.strategy.IdHandler;
import io.apicurio.registry.utils.serde.strategy.Legacy4ByteIdHandler;
import io.apicurio.registry.utils.serde.util.HeaderUtils;
import io.apicurio.registry.utils.serde.util.Utils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.kafka.common.errors.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKafkaSerDe<T extends AbstractKafkaSerDe<T>>
implements AutoCloseable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String REGISTRY_URL_CONFIG_PARAM = "apicurio.registry.url";
    @Deprecated
    public static final String REGISTRY_CACHED_CONFIG_PARAM = "apicurio.registry.cached";
    public static final String REGISTRY_ID_HANDLER_CONFIG_PARAM = "apicurio.registry.id-handler";
    public static final String REGISTRY_CONFLUENT_ID_HANDLER_CONFIG_PARAM = "apicurio.registry.as-confluent";
    public static final String USE_HEADERS = "apicurio.registry.use.headers";
    public static final String REGISTRY_REQUEST_HEADERS_PREFIX = "apicurio.registry.request.headers.";
    public static final String REGISTRY_REQUEST_TRUSTSTORE_LOCATION = "apicurio.registry.request.ssl.truststore.location";
    public static final String REGISTRY_REQUEST_TRUSTSTORE_TYPE = "apicurio.registry.request.ssl.truststore.type";
    public static final String REGISTRY_REQUEST_TRUSTSTORE_PASSWORD = "apicurio.registry.request.ssl.truststore.password";
    public static final String REGISTRY_REQUEST_KEYSTORE_LOCATION = "apicurio.registry.request.ssl.keystore.location";
    public static final String REGISTRY_REQUEST_KEYSTORE_TYPE = "apicurio.registry.request.ssl.keystore.type";
    public static final String REGISTRY_REQUEST_KEYSTORE_PASSWORD = "apicurio.registry.request.ssl.keystore.password";
    public static final String REGISTRY_REQUEST_KEY_PASSWORD = "apicurio.registry.request.ssl.key.password";
    public static final byte MAGIC_BYTE = 0;
    protected boolean key;
    private IdHandler idHandler;
    private RegistryService client;
    protected HeaderUtils headerUtils;

    public AbstractKafkaSerDe() {
    }

    public AbstractKafkaSerDe(RegistryService client) {
        this.client = client;
    }

    public static ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer;
    }

    protected T self() {
        return (T)this;
    }

    public IdHandler getIdHandler() {
        if (this.idHandler == null) {
            this.idHandler = new DefaultIdHandler();
        }
        return this.idHandler;
    }

    public T setIdHandler(IdHandler idHandler) {
        this.idHandler = Objects.requireNonNull(idHandler);
        return this.self();
    }

    public T asLegacyId() {
        return this.setIdHandler(new Legacy4ByteIdHandler());
    }

    protected void configure(Map<String, ?> configs, boolean isKey) {
        if (this.client == null) {
            String baseUrl = (String)configs.get(REGISTRY_URL_CONFIG_PARAM);
            if (baseUrl == null) {
                throw new IllegalArgumentException("Missing registry base url, set apicurio.registry.url");
            }
            try {
                this.client = CompatibleClient.createCompatible((String)baseUrl, new HashMap(configs));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.idHandler == null) {
            Object idh = configs.get(REGISTRY_ID_HANDLER_CONFIG_PARAM);
            this.instantiate(IdHandler.class, idh, this::setIdHandler);
            if (Utils.isTrue(configs.get(REGISTRY_CONFLUENT_ID_HANDLER_CONFIG_PARAM))) {
                if (this.idHandler != null && !(this.idHandler instanceof Legacy4ByteIdHandler)) {
                    this.log.warn(String.format("Duplicate id-handler configuration: %s vs. %s", idh, "as-confluent"));
                }
                this.setIdHandler(new Legacy4ByteIdHandler());
            }
        }
        this.key = isKey;
    }

    protected <V> void instantiate(Class<V> type, Object value, Consumer<V> setter) {
        if (value != null) {
            if (type.isInstance(value)) {
                setter.accept(type.cast(value));
            } else if (value instanceof Class && type.isAssignableFrom((Class)value)) {
                setter.accept(this.instantiate((Class)value));
            } else if (value instanceof String) {
                Class<V> clazz = this.loadClass(type, (String)value);
                setter.accept(this.instantiate(clazz));
            } else {
                throw new IllegalArgumentException(String.format("Cannot handle configuration [%s]: %s", type.getName(), value));
            }
        }
    }

    protected <V> Class<V> loadClass(Class<V> type, String className) {
        try {
            return type.getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected <V> V instantiate(Class<V> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected RegistryService getClient() {
        return this.client;
    }

    public void reset() {
        if (this.client != null) {
            this.client.reset();
        }
    }

    @Override
    public void close() {
        IoUtil.closeIgnore((AutoCloseable)this.client);
    }

    protected boolean isKey() {
        return this.key;
    }

    public Object setKey(boolean key) {
        this.key = key;
        return this.self();
    }

    protected Long toGlobalId(String artifactId, Integer version) {
        if (artifactId == null) {
            throw new RuntimeException("ArtifactId not found in headers.");
        }
        if (version == null) {
            ArtifactMetaData amd = this.getClient().getArtifactMetaData(artifactId);
            return amd.getGlobalId();
        }
        VersionMetaData vmd = this.getClient().getArtifactVersionMetaData(version, artifactId);
        return vmd.getGlobalId();
    }
}

