/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.amqp;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAmqpSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_AMQP_PATH_DESTINATION_TYPE_CONF = "camel.source.path.destinationType";
    public static final String CAMEL_SOURCE_AMQP_PATH_DESTINATION_TYPE_DOC = "The kind of destination to use One of: [queue] [topic] [temp-queue] [temp-topic]";
    public static final String CAMEL_SOURCE_AMQP_PATH_DESTINATION_TYPE_DEFAULT = "queue";
    public static final String CAMEL_SOURCE_AMQP_PATH_DESTINATION_NAME_CONF = "camel.source.path.destinationName";
    public static final String CAMEL_SOURCE_AMQP_PATH_DESTINATION_NAME_DOC = "Name of the queue or topic to use as destination";
    public static final String CAMEL_SOURCE_AMQP_PATH_DESTINATION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CLIENT_ID_CONF = "camel.source.endpoint.clientId";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CLIENT_ID_DOC = "Sets the JMS client ID to use. Note that this value, if specified, must be unique and can only be used by a single JMS connection instance. It is typically only required for durable topic subscriptions. If using Apache ActiveMQ you may prefer to use Virtual Topics instead.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CONNECTION_FACTORY_CONF = "camel.source.endpoint.connectionFactory";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CONNECTION_FACTORY_DOC = "The connection factory to be use. A connection factory must be configured either on the component or endpoint.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CONNECTION_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DISABLE_REPLY_TO_CONF = "camel.source.endpoint.disableReplyTo";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DISABLE_REPLY_TO_DOC = "Specifies whether Camel ignores the JMSReplyTo header in messages. If true, Camel does not send a reply back to the destination specified in the JMSReplyTo header. You can use this option if you want Camel to consume from a route and you do not want Camel to automatically send back a reply message because another component in your code handles the reply message. You can also use this option if you want to use Camel as a proxy between different message brokers and you want to route message from one system to another.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_DISABLE_REPLY_TO_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_CONF = "camel.source.endpoint.durableSubscriptionName";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_DOC = "The durable subscriber name for specifying durable topic subscriptions. The clientId option must be configured as well.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_JMS_MESSAGE_TYPE_CONF = "camel.source.endpoint.jmsMessageType";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_JMS_MESSAGE_TYPE_DOC = "Allows you to force the use of a specific javax.jms.Message implementation for sending JMS messages. Possible values are: Bytes, Map, Object, Stream, Text. By default, Camel would determine which JMS message type to use from the In body type. This option allows you to specify it. One of: [Bytes] [Map] [Object] [Stream] [Text]";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_JMS_MESSAGE_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TEST_CONNECTION_ON_STARTUP_CONF = "camel.source.endpoint.testConnectionOnStartup";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DOC = "Specifies whether to test the connection on startup. This ensures that when Camel starts that all the JMS consumers have a valid connection to the JMS broker. If a connection cannot be granted then Camel throws an exception on startup. This ensures that Camel is not started with failed connections. The JMS producers is tested as well.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ACKNOWLEDGEMENT_MODE_NAME_CONF = "camel.source.endpoint.acknowledgementModeName";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ACKNOWLEDGEMENT_MODE_NAME_DOC = "The JMS acknowledgement name, which is one of: SESSION_TRANSACTED, CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE One of: [SESSION_TRANSACTED] [CLIENT_ACKNOWLEDGE] [AUTO_ACKNOWLEDGE] [DUPS_OK_ACKNOWLEDGE]";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ACKNOWLEDGEMENT_MODE_NAME_DEFAULT = "AUTO_ACKNOWLEDGE";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_CONSUMER_CONF = "camel.source.endpoint.asyncConsumer";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_CONSUMER_DOC = "Whether the JmsConsumer processes the Exchange asynchronously. If enabled then the JmsConsumer may pickup the next message from the JMS queue, while the previous message is being processed asynchronously (by the Asynchronous Routing Engine). This means that messages may be processed not 100% strictly in order. If disabled (as default) then the Exchange is fully processed before the JmsConsumer will pickup the next message from the JMS queue. Note if transacted has been enabled, then asyncConsumer=true does not run asynchronously, as transaction must be executed synchronously (Camel 3.0 may support async transactions).";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_CONSUMER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_AUTO_STARTUP_CONF = "camel.source.endpoint.autoStartup";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_AUTO_STARTUP_DOC = "Specifies whether the consumer container should auto-startup.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_AUTO_STARTUP_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_CONF = "camel.source.endpoint.cacheLevel";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_DOC = "Sets the cache level by ID for the underlying JMS resources. See cacheLevelName option for more details.";
    public static final Integer CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_NAME_CONF = "camel.source.endpoint.cacheLevelName";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_NAME_DOC = "Sets the cache level by name for the underlying JMS resources. Possible values are: CACHE_AUTO, CACHE_CONNECTION, CACHE_CONSUMER, CACHE_NONE, and CACHE_SESSION. The default setting is CACHE_AUTO. See the Spring documentation and Transactions Cache Levels for more information. One of: [CACHE_AUTO] [CACHE_CONNECTION] [CACHE_CONSUMER] [CACHE_NONE] [CACHE_SESSION]";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_NAME_DEFAULT = "CACHE_AUTO";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CONCURRENT_CONSUMERS_CONF = "camel.source.endpoint.concurrentConsumers";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CONCURRENT_CONSUMERS_DOC = "Specifies the default number of concurrent consumers when consuming from JMS (not for request/reply over JMS). See also the maxMessagesPerTask option to control dynamic scaling up/down of threads. When doing request/reply over JMS then the option replyToConcurrentConsumers is used to control number of concurrent consumers on the reply message listener.";
    public static final Integer CAMEL_SOURCE_AMQP_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MAX_CONCURRENT_CONSUMERS_CONF = "camel.source.endpoint.maxConcurrentConsumers";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MAX_CONCURRENT_CONSUMERS_DOC = "Specifies the maximum number of concurrent consumers when consuming from JMS (not for request/reply over JMS). See also the maxMessagesPerTask option to control dynamic scaling up/down of threads. When doing request/reply over JMS then the option replyToMaxConcurrentConsumers is used to control number of concurrent consumers on the reply message listener.";
    public static final Integer CAMEL_SOURCE_AMQP_ENDPOINT_MAX_CONCURRENT_CONSUMERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_CONF = "camel.source.endpoint.replyTo";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DOC = "Provides an explicit ReplyTo destination, which overrides any incoming value of Message.getJMSReplyTo().";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_CONF = "camel.source.endpoint.replyToDeliveryPersistent";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_DOC = "Specifies whether to use persistent delivery by default for replies.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SELECTOR_CONF = "camel.source.endpoint.selector";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SELECTOR_DOC = "Sets the JMS selector to use";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SELECTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_DURABLE_CONF = "camel.source.endpoint.subscriptionDurable";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_DURABLE_DOC = "Set whether to make the subscription durable. The durable subscription name to be used can be specified through the subscriptionName property. Default is false. Set this to true to register a durable subscription, typically in combination with a subscriptionName value (unless your message listener class name is good enough as subscription name). Only makes sense when listening to a topic (pub-sub domain), therefore this method switches the pubSubDomain flag as well.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_DURABLE_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_NAME_CONF = "camel.source.endpoint.subscriptionName";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_NAME_DOC = "Set the name of a subscription to create. To be applied in case of a topic (pub-sub domain) with a shared or durable subscription. The subscription name needs to be unique within this client's JMS client id. Default is the class name of the specified message listener. Note: Only 1 concurrent consumer (which is the default of this message listener container) is allowed for each subscription, except for a shared subscription (which requires JMS 2.0).";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_SHARED_CONF = "camel.source.endpoint.subscriptionShared";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_SHARED_DOC = "Set whether to make the subscription shared. The shared subscription name to be used can be specified through the subscriptionName property. Default is false. Set this to true to register a shared subscription, typically in combination with a subscriptionName value (unless your message listener class name is good enough as subscription name). Note that shared subscriptions may also be durable, so this flag can (and often will) be combined with subscriptionDurable as well. Only makes sense when listening to a topic (pub-sub domain), therefore this method switches the pubSubDomain flag as well. Requires a JMS 2.0 compatible message broker.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_SHARED_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ACCEPT_MESSAGES_WHILE_STOPPING_CONF = "camel.source.endpoint.acceptMessagesWhileStopping";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ACCEPT_MESSAGES_WHILE_STOPPING_DOC = "Specifies whether the consumer accept messages while it is stopping. You may consider enabling this option, if you start and stop JMS routes at runtime, while there are still messages enqueued on the queue. If this option is false, and you stop the JMS route, then messages may be rejected, and the JMS broker would have to attempt redeliveries, which yet again may be rejected, and eventually the message may be moved at a dead letter queue on the JMS broker. To avoid this its recommended to enable this option.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_ACCEPT_MESSAGES_WHILE_STOPPING_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_REPLY_MANAGER_QUICK_STOP_CONF = "camel.source.endpoint.allowReplyManagerQuickStop";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_REPLY_MANAGER_QUICK_STOP_DOC = "Whether the DefaultMessageListenerContainer used in the reply managers for request-reply messaging allow the DefaultMessageListenerContainer.runningAllowed flag to quick stop in case JmsConfiguration#isAcceptMessagesWhileStopping is enabled, and org.apache.camel.CamelContext is currently being stopped. This quick stop ability is enabled by default in the regular JMS consumers but to enable for reply managers you must enable this flag.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_REPLY_MANAGER_QUICK_STOP_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CONSUMER_TYPE_CONF = "camel.source.endpoint.consumerType";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CONSUMER_TYPE_DOC = "The consumer type to use, which can be one of: Simple, Default, or Custom. The consumer type determines which Spring JMS listener to use. Default will use org.springframework.jms.listener.DefaultMessageListenerContainer, Simple will use org.springframework.jms.listener.SimpleMessageListenerContainer. When Custom is specified, the MessageListenerContainerFactory defined by the messageListenerContainerFactory option will determine what org.springframework.jms.listener.AbstractMessageListenerContainer to use. One of: [Simple] [Default] [Custom]";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_CONSUMER_TYPE_DEFAULT = "Default";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DEFAULT_TASK_EXECUTOR_TYPE_CONF = "camel.source.endpoint.defaultTaskExecutorType";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DEFAULT_TASK_EXECUTOR_TYPE_DOC = "Specifies what default TaskExecutor type to use in the DefaultMessageListenerContainer, for both consumer endpoints and the ReplyTo consumer of producer endpoints. Possible values: SimpleAsync (uses Spring's SimpleAsyncTaskExecutor) or ThreadPool (uses Spring's ThreadPoolTaskExecutor with optimal values - cached threadpool-like). If not set, it defaults to the previous behaviour, which uses a cached thread pool for consumer endpoints and SimpleAsync for reply consumers. The use of ThreadPool is recommended to reduce thread trash in elastic configurations with dynamically increasing and decreasing concurrent consumers. One of: [ThreadPool] [SimpleAsync]";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DEFAULT_TASK_EXECUTOR_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_CONF = "camel.source.endpoint.eagerLoadingOfProperties";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_DOC = "Enables eager loading of JMS properties and payload as soon as a message is loaded which generally is inefficient as the JMS properties may not be required but sometimes can catch early any issues with the underlying JMS provider and the use of JMS properties. See also the option eagerPoisonBody.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_POISON_BODY_CONF = "camel.source.endpoint.eagerPoisonBody";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_POISON_BODY_DOC = "If eagerLoadingOfProperties is enabled and the JMS message payload (JMS body or JMS properties) is poison (cannot be read/mapped), then set this text as the message body instead so the message can be processed (the cause of the poison are already stored as exception on the Exchange). This can be turned off by setting eagerPoisonBody=false. See also the option eagerLoadingOfProperties.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_POISON_BODY_DEFAULT = "Poison JMS message due to ${exception.message}";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXPOSE_LISTENER_SESSION_CONF = "camel.source.endpoint.exposeListenerSession";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXPOSE_LISTENER_SESSION_DOC = "Specifies whether the listener session should be exposed when consuming messages.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_EXPOSE_LISTENER_SESSION_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_CONF = "camel.source.endpoint.replyToSameDestinationAllowed";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_DOC = "Whether a JMS consumer is allowed to send a reply message to the same destination that the consumer is using to consume from. This prevents an endless loop by consuming and sending back the same message to itself.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TASK_EXECUTOR_CONF = "camel.source.endpoint.taskExecutor";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TASK_EXECUTOR_DOC = "Allows you to specify a custom task executor for consuming messages.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TASK_EXECUTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_SERIALIZED_HEADERS_CONF = "camel.source.endpoint.allowSerializedHeaders";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DOC = "Controls whether or not to include serialized headers. Applies only when transferExchange is true. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ARTEMIS_STREAMING_ENABLED_CONF = "camel.source.endpoint.artemisStreamingEnabled";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ARTEMIS_STREAMING_ENABLED_DOC = "Whether optimizing for Apache Artemis streaming mode.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_ARTEMIS_STREAMING_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_START_LISTENER_CONF = "camel.source.endpoint.asyncStartListener";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_START_LISTENER_DOC = "Whether to startup the JmsConsumer message listener asynchronously, when starting a route. For example if a JmsConsumer cannot get a connection to a remote JMS broker, then it may block while retrying and/or failover. This will cause Camel to block while starting routes. By setting this option to true, you will let routes startup, while the JmsConsumer connects to the JMS broker using a dedicated thread in asynchronous mode. If this option is used, then beware that if the connection could not be established, then an exception is logged at WARN level, and the consumer will not be able to receive messages; You can then restart the route to retry.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_START_LISTENER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_STOP_LISTENER_CONF = "camel.source.endpoint.asyncStopListener";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_STOP_LISTENER_DOC = "Whether to stop the JmsConsumer message listener asynchronously, when stopping a route.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_STOP_LISTENER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DESTINATION_RESOLVER_CONF = "camel.source.endpoint.destinationResolver";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DESTINATION_RESOLVER_DOC = "A pluggable org.springframework.jms.support.destination.DestinationResolver that allows you to use your own resolver (for example, to lookup the real destination in a JNDI registry).";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_DESTINATION_RESOLVER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_CONF = "camel.source.endpoint.errorHandler";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_DOC = "Specifies a org.springframework.util.ErrorHandler to be invoked in case of any uncaught exceptions thrown while processing a Message. By default these exceptions will be logged at the WARN level, if no errorHandler has been configured. You can configure logging level and whether stack traces should be logged using errorHandlerLoggingLevel and errorHandlerLogStackTrace options. This makes it much easier to configure, than having to code a custom errorHandler.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_LISTENER_CONF = "camel.source.endpoint.exceptionListener";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_LISTENER_DOC = "Specifies the JMS Exception Listener that is to be notified of any underlying JMS exceptions.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_LISTENER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_HEADER_FILTER_STRATEGY_CONF = "camel.source.endpoint.headerFilterStrategy";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_HEADER_FILTER_STRATEGY_DOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_CONSUMER_LIMIT_CONF = "camel.source.endpoint.idleConsumerLimit";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_CONSUMER_LIMIT_DOC = "Specify the limit for the number of consumers that are allowed to be idle at any given time.";
    public static final Integer CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_CONSUMER_LIMIT_DEFAULT = 1;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_TASK_EXECUTION_LIMIT_CONF = "camel.source.endpoint.idleTaskExecutionLimit";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_TASK_EXECUTION_LIMIT_DOC = "Specifies the limit for idle executions of a receive task, not having received any message within its execution. If this limit is reached, the task will shut down and leave receiving to other executing tasks (in the case of dynamic scheduling; see the maxConcurrentConsumers setting). There is additional doc available from Spring.";
    public static final Integer CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_TASK_EXECUTION_LIMIT_DEFAULT = 1;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_CONF = "camel.source.endpoint.includeAllJMSXProperties";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_DOC = "Whether to include all JMSXxxx properties when mapping from JMS to Camel Message. Setting this to true will include properties such as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom headerFilterStrategy then this option does not apply.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_CONF = "camel.source.endpoint.jmsKeyFormatStrategy";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_DOC = "Pluggable strategy for encoding and decoding JMS keys so they can be compliant with the JMS specification. Camel provides two implementations out of the box: default and passthrough. The default strategy will safely marshal dots and hyphens (. and -). The passthrough strategy leaves the key as is. Can be used for JMS brokers which do not care whether JMS header keys contain illegal characters. You can provide your own implementation of the org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it using the # notation. One of: [default] [passthrough]";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MAP_JMS_MESSAGE_CONF = "camel.source.endpoint.mapJmsMessage";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MAP_JMS_MESSAGE_DOC = "Specifies whether Camel should auto map the received JMS message to a suited payload type, such as javax.jms.TextMessage to a String etc.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_MAP_JMS_MESSAGE_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MAX_MESSAGES_PER_TASK_CONF = "camel.source.endpoint.maxMessagesPerTask";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MAX_MESSAGES_PER_TASK_DOC = "The number of messages per task. -1 is unlimited. If you use a range for concurrent consumers (eg min max), then this option can be used to set a value to eg 100 to control how fast the consumers will shrink when less work is required.";
    public static final Integer CAMEL_SOURCE_AMQP_ENDPOINT_MAX_MESSAGES_PER_TASK_DEFAULT = -1;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CONVERTER_CONF = "camel.source.endpoint.messageConverter";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CONVERTER_DOC = "To use a custom Spring org.springframework.jms.support.converter.MessageConverter so you can be in control how to map to/from a javax.jms.Message.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CONVERTER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CREATED_STRATEGY_CONF = "camel.source.endpoint.messageCreatedStrategy";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CREATED_STRATEGY_DOC = "To use the given MessageCreatedStrategy which are invoked when Camel creates new instances of javax.jms.Message objects when Camel is sending a JMS message.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CREATED_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_ID_ENABLED_CONF = "camel.source.endpoint.messageIdEnabled";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_ID_ENABLED_DOC = "When sending, specifies whether message IDs should be added. This is just an hint to the JMS broker. If the JMS provider accepts this hint, these messages must have the message ID set to null; if the provider ignores the hint, the message ID must be set to its normal unique value.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_ID_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_LISTENER_CONTAINER_FACTORY_CONF = "camel.source.endpoint.messageListenerContainerFactory";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_LISTENER_CONTAINER_FACTORY_DOC = "Registry ID of the MessageListenerContainerFactory used to determine what org.springframework.jms.listener.AbstractMessageListenerContainer to use to consume messages. Setting this will automatically set consumerType to Custom.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_LISTENER_CONTAINER_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_TIMESTAMP_ENABLED_CONF = "camel.source.endpoint.messageTimestampEnabled";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_TIMESTAMP_ENABLED_DOC = "Specifies whether timestamps should be enabled by default on sending messages. This is just an hint to the JMS broker. If the JMS provider accepts this hint, these messages must have the timestamp set to zero; if the provider ignores the hint the timestamp must be set to its normal value.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_TIMESTAMP_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_PUB_SUB_NO_LOCAL_CONF = "camel.source.endpoint.pubSubNoLocal";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_PUB_SUB_NO_LOCAL_DOC = "Specifies whether to inhibit the delivery of messages published by its own connection.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_PUB_SUB_NO_LOCAL_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_RECEIVE_TIMEOUT_CONF = "camel.source.endpoint.receiveTimeout";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_RECEIVE_TIMEOUT_DOC = "The timeout for receiving messages (in milliseconds).";
    public static final Long CAMEL_SOURCE_AMQP_ENDPOINT_RECEIVE_TIMEOUT_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_RECOVERY_INTERVAL_CONF = "camel.source.endpoint.recoveryInterval";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_RECOVERY_INTERVAL_DOC = "Specifies the interval between recovery attempts, i.e. when a connection is being refreshed, in milliseconds. The default is 5000 ms, that is, 5 seconds.";
    public static final Long CAMEL_SOURCE_AMQP_ENDPOINT_RECOVERY_INTERVAL_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF = "camel.source.endpoint.requestTimeoutCheckerInterval";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC = "Configures how often Camel should check for timed out Exchanges when doing request/reply over JMS. By default Camel checks once per second. But if you must react faster when a timeout occurs, then you can lower this interval, to check more frequently. The timeout is determined by the option requestTimeout.";
    public static final Long CAMEL_SOURCE_AMQP_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCEPTION_CONF = "camel.source.endpoint.transferException";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCEPTION_DOC = "If enabled and you are using Request Reply messaging (InOut) and an Exchange failed on the consumer side, then the caused Exception will be send back in response as a javax.jms.ObjectMessage. If the client is Camel, the returned Exception is rethrown. This allows you to use Camel JMS as a bridge in your routing - for example, using persistent queues to enable robust routing. Notice that if you also have transferExchange enabled, this option takes precedence. The caught exception is required to be serializable. The original Exception on the consumer side can be wrapped in an outer exception such as org.apache.camel.RuntimeCamelException when returned to the producer. Use this with caution as the data is using Java Object serialization and requires the received to be able to deserialize the data at Class level, which forces a strong coupling between the producers and consumer!";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCHANGE_CONF = "camel.source.endpoint.transferExchange";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCHANGE_DOC = "You can transfer the exchange over the wire instead of just the body and headers. The following fields are transferred: In body, Out body, Fault body, In headers, Out headers, Fault headers, exchange properties, exchange exception. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level. You must enable this option on both the producer and consumer side, so Camel knows the payloads is an Exchange and not a regular payload. Use this with caution as the data is using Java Object serialization and requires the received to be able to deserialize the data at Class level, which forces a strong coupling between the producers and consumer having to use compatible Camel versions!";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCHANGE_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_USE_MESSAGE_IDAS_CORRELATION_IDCONF = "camel.source.endpoint.useMessageIDAsCorrelationID";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_USE_MESSAGE_IDAS_CORRELATION_IDDOC = "Specifies whether JMSMessageID should always be used as JMSCorrelationID for InOut messages.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_USE_MESSAGE_IDAS_CORRELATION_IDDEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_CONF = "camel.source.endpoint.waitForProvisionCorrelationToBeUpdatedCounter";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_DOC = "Number of times to wait for provisional correlation id to be updated to the actual correlation id when doing request/reply over JMS and when the option useMessageIDAsCorrelationID is enabled.";
    public static final Integer CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_DEFAULT = 50;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_CONF = "camel.source.endpoint.waitForProvisionCorrelationToBeUpdatedThreadSleepingTime";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_DOC = "Interval in millis to sleep each time while waiting for provisional correlation id to be updated.";
    public static final Long CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_DEFAULT = 100L;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOGGING_LEVEL_CONF = "camel.source.endpoint.errorHandlerLoggingLevel";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOGGING_LEVEL_DOC = "Allows to configure the default errorHandler logging level for logging uncaught exceptions. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOGGING_LEVEL_DEFAULT = "WARN";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOG_STACK_TRACE_CONF = "camel.source.endpoint.errorHandlerLogStackTrace";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOG_STACK_TRACE_DOC = "Allows to control whether stacktraces should be logged or not, by the default errorHandler.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOG_STACK_TRACE_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_PASSWORD_DOC = "Password to use with the ConnectionFactory. You can also configure username/password directly on the ConnectionFactory.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_USERNAME_CONF = "camel.source.endpoint.username";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_USERNAME_DOC = "Username to use with the ConnectionFactory. You can also configure username/password directly on the ConnectionFactory.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTED_CONF = "camel.source.endpoint.transacted";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTED_DOC = "Specifies whether to use transacted mode";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTED_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_LAZY_CREATE_TRANSACTION_MANAGER_CONF = "camel.source.endpoint.lazyCreateTransactionManager";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_LAZY_CREATE_TRANSACTION_MANAGER_DOC = "If true, Camel will create a JmsTransactionManager, if there is no transactionManager injected when option transacted=true.";
    public static final Boolean CAMEL_SOURCE_AMQP_ENDPOINT_LAZY_CREATE_TRANSACTION_MANAGER_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_MANAGER_CONF = "camel.source.endpoint.transactionManager";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_MANAGER_DOC = "The Spring transaction manager to use.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_MANAGER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_NAME_CONF = "camel.source.endpoint.transactionName";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_NAME_DOC = "The name of the transaction to use.";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_TIMEOUT_CONF = "camel.source.endpoint.transactionTimeout";
    public static final String CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_TIMEOUT_DOC = "The timeout value of the transaction (in seconds), if using transacted mode.";
    public static final Integer CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_TIMEOUT_DEFAULT = -1;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CLIENT_ID_CONF = "camel.component.amqp.clientId";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CLIENT_ID_DOC = "Sets the JMS client ID to use. Note that this value, if specified, must be unique and can only be used by a single JMS connection instance. It is typically only required for durable topic subscriptions. If using Apache ActiveMQ you may prefer to use Virtual Topics instead.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONNECTION_FACTORY_CONF = "camel.component.amqp.connectionFactory";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONNECTION_FACTORY_DOC = "The connection factory to be use. A connection factory must be configured either on the component or endpoint.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONNECTION_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DISABLE_REPLY_TO_CONF = "camel.component.amqp.disableReplyTo";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DISABLE_REPLY_TO_DOC = "Specifies whether Camel ignores the JMSReplyTo header in messages. If true, Camel does not send a reply back to the destination specified in the JMSReplyTo header. You can use this option if you want Camel to consume from a route and you do not want Camel to automatically send back a reply message because another component in your code handles the reply message. You can also use this option if you want to use Camel as a proxy between different message brokers and you want to route message from one system to another.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_DISABLE_REPLY_TO_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DURABLE_SUBSCRIPTION_NAME_CONF = "camel.component.amqp.durableSubscriptionName";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DURABLE_SUBSCRIPTION_NAME_DOC = "The durable subscriber name for specifying durable topic subscriptions. The clientId option must be configured as well.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DURABLE_SUBSCRIPTION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_AMQP_ANNOTATIONS_CONF = "camel.component.amqp.includeAmqpAnnotations";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_AMQP_ANNOTATIONS_DOC = "Whether to include AMQP annotations when mapping from AMQP to Camel Message. Setting this to true maps AMQP message annotations that contain a JMS_AMQP_MA_ prefix to message headers. Due to limitations in Apache Qpid JMS API, currently delivery annotations are ignored.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_AMQP_ANNOTATIONS_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_JMS_MESSAGE_TYPE_CONF = "camel.component.amqp.jmsMessageType";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_JMS_MESSAGE_TYPE_DOC = "Allows you to force the use of a specific javax.jms.Message implementation for sending JMS messages. Possible values are: Bytes, Map, Object, Stream, Text. By default, Camel would determine which JMS message type to use from the In body type. This option allows you to specify it. One of: [Bytes] [Map] [Object] [Stream] [Text]";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_JMS_MESSAGE_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TEST_CONNECTION_ON_STARTUP_CONF = "camel.component.amqp.testConnectionOnStartup";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TEST_CONNECTION_ON_STARTUP_DOC = "Specifies whether to test the connection on startup. This ensures that when Camel starts that all the JMS consumers have a valid connection to the JMS broker. If a connection cannot be granted then Camel throws an exception on startup. This ensures that Camel is not started with failed connections. The JMS producers is tested as well.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_TEST_CONNECTION_ON_STARTUP_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ACKNOWLEDGEMENT_MODE_NAME_CONF = "camel.component.amqp.acknowledgementModeName";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ACKNOWLEDGEMENT_MODE_NAME_DOC = "The JMS acknowledgement name, which is one of: SESSION_TRANSACTED, CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE One of: [SESSION_TRANSACTED] [CLIENT_ACKNOWLEDGE] [AUTO_ACKNOWLEDGE] [DUPS_OK_ACKNOWLEDGE]";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ACKNOWLEDGEMENT_MODE_NAME_DEFAULT = "AUTO_ACKNOWLEDGE";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_CONSUMER_CONF = "camel.component.amqp.asyncConsumer";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_CONSUMER_DOC = "Whether the JmsConsumer processes the Exchange asynchronously. If enabled then the JmsConsumer may pickup the next message from the JMS queue, while the previous message is being processed asynchronously (by the Asynchronous Routing Engine). This means that messages may be processed not 100% strictly in order. If disabled (as default) then the Exchange is fully processed before the JmsConsumer will pickup the next message from the JMS queue. Note if transacted has been enabled, then asyncConsumer=true does not run asynchronously, as transaction must be executed synchronously (Camel 3.0 may support async transactions).";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_CONSUMER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_AUTO_STARTUP_CONF = "camel.component.amqp.autoStartup";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_AUTO_STARTUP_DOC = "Specifies whether the consumer container should auto-startup.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_AUTO_STARTUP_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_CONF = "camel.component.amqp.cacheLevel";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_DOC = "Sets the cache level by ID for the underlying JMS resources. See cacheLevelName option for more details.";
    public static final Integer CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_NAME_CONF = "camel.component.amqp.cacheLevelName";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_NAME_DOC = "Sets the cache level by name for the underlying JMS resources. Possible values are: CACHE_AUTO, CACHE_CONNECTION, CACHE_CONSUMER, CACHE_NONE, and CACHE_SESSION. The default setting is CACHE_AUTO. See the Spring documentation and Transactions Cache Levels for more information. One of: [CACHE_AUTO] [CACHE_CONNECTION] [CACHE_CONSUMER] [CACHE_NONE] [CACHE_SESSION]";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_NAME_DEFAULT = "CACHE_AUTO";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONCURRENT_CONSUMERS_CONF = "camel.component.amqp.concurrentConsumers";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONCURRENT_CONSUMERS_DOC = "Specifies the default number of concurrent consumers when consuming from JMS (not for request/reply over JMS). See also the maxMessagesPerTask option to control dynamic scaling up/down of threads. When doing request/reply over JMS then the option replyToConcurrentConsumers is used to control number of concurrent consumers on the reply message listener.";
    public static final Integer CAMEL_SOURCE_AMQP_COMPONENT_CONCURRENT_CONSUMERS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MAX_CONCURRENT_CONSUMERS_CONF = "camel.component.amqp.maxConcurrentConsumers";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MAX_CONCURRENT_CONSUMERS_DOC = "Specifies the maximum number of concurrent consumers when consuming from JMS (not for request/reply over JMS). See also the maxMessagesPerTask option to control dynamic scaling up/down of threads. When doing request/reply over JMS then the option replyToMaxConcurrentConsumers is used to control number of concurrent consumers on the reply message listener.";
    public static final Integer CAMEL_SOURCE_AMQP_COMPONENT_MAX_CONCURRENT_CONSUMERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_CONF = "camel.component.amqp.replyTo";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DOC = "Provides an explicit ReplyTo destination, which overrides any incoming value of Message.getJMSReplyTo().";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DELIVERY_PERSISTENT_CONF = "camel.component.amqp.replyToDeliveryPersistent";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DELIVERY_PERSISTENT_DOC = "Specifies whether to use persistent delivery by default for replies.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DELIVERY_PERSISTENT_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SELECTOR_CONF = "camel.component.amqp.selector";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SELECTOR_DOC = "Sets the JMS selector to use";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SELECTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_DURABLE_CONF = "camel.component.amqp.subscriptionDurable";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_DURABLE_DOC = "Set whether to make the subscription durable. The durable subscription name to be used can be specified through the subscriptionName property. Default is false. Set this to true to register a durable subscription, typically in combination with a subscriptionName value (unless your message listener class name is good enough as subscription name). Only makes sense when listening to a topic (pub-sub domain), therefore this method switches the pubSubDomain flag as well.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_DURABLE_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_NAME_CONF = "camel.component.amqp.subscriptionName";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_NAME_DOC = "Set the name of a subscription to create. To be applied in case of a topic (pub-sub domain) with a shared or durable subscription. The subscription name needs to be unique within this client's JMS client id. Default is the class name of the specified message listener. Note: Only 1 concurrent consumer (which is the default of this message listener container) is allowed for each subscription, except for a shared subscription (which requires JMS 2.0).";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_SHARED_CONF = "camel.component.amqp.subscriptionShared";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_SHARED_DOC = "Set whether to make the subscription shared. The shared subscription name to be used can be specified through the subscriptionName property. Default is false. Set this to true to register a shared subscription, typically in combination with a subscriptionName value (unless your message listener class name is good enough as subscription name). Note that shared subscriptions may also be durable, so this flag can (and often will) be combined with subscriptionDurable as well. Only makes sense when listening to a topic (pub-sub domain), therefore this method switches the pubSubDomain flag as well. Requires a JMS 2.0 compatible message broker.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_SHARED_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ACCEPT_MESSAGES_WHILE_STOPPING_CONF = "camel.component.amqp.acceptMessagesWhileStopping";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ACCEPT_MESSAGES_WHILE_STOPPING_DOC = "Specifies whether the consumer accept messages while it is stopping. You may consider enabling this option, if you start and stop JMS routes at runtime, while there are still messages enqueued on the queue. If this option is false, and you stop the JMS route, then messages may be rejected, and the JMS broker would have to attempt redeliveries, which yet again may be rejected, and eventually the message may be moved at a dead letter queue on the JMS broker. To avoid this its recommended to enable this option.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ACCEPT_MESSAGES_WHILE_STOPPING_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_REPLY_MANAGER_QUICK_STOP_CONF = "camel.component.amqp.allowReplyManagerQuickStop";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_REPLY_MANAGER_QUICK_STOP_DOC = "Whether the DefaultMessageListenerContainer used in the reply managers for request-reply messaging allow the DefaultMessageListenerContainer.runningAllowed flag to quick stop in case JmsConfiguration#isAcceptMessagesWhileStopping is enabled, and org.apache.camel.CamelContext is currently being stopped. This quick stop ability is enabled by default in the regular JMS consumers but to enable for reply managers you must enable this flag.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_REPLY_MANAGER_QUICK_STOP_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONSUMER_TYPE_CONF = "camel.component.amqp.consumerType";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONSUMER_TYPE_DOC = "The consumer type to use, which can be one of: Simple, Default, or Custom. The consumer type determines which Spring JMS listener to use. Default will use org.springframework.jms.listener.DefaultMessageListenerContainer, Simple will use org.springframework.jms.listener.SimpleMessageListenerContainer. When Custom is specified, the MessageListenerContainerFactory defined by the messageListenerContainerFactory option will determine what org.springframework.jms.listener.AbstractMessageListenerContainer to use. One of: [Simple] [Default] [Custom]";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONSUMER_TYPE_DEFAULT = "Default";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DEFAULT_TASK_EXECUTOR_TYPE_CONF = "camel.component.amqp.defaultTaskExecutorType";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DEFAULT_TASK_EXECUTOR_TYPE_DOC = "Specifies what default TaskExecutor type to use in the DefaultMessageListenerContainer, for both consumer endpoints and the ReplyTo consumer of producer endpoints. Possible values: SimpleAsync (uses Spring's SimpleAsyncTaskExecutor) or ThreadPool (uses Spring's ThreadPoolTaskExecutor with optimal values - cached threadpool-like). If not set, it defaults to the previous behaviour, which uses a cached thread pool for consumer endpoints and SimpleAsync for reply consumers. The use of ThreadPool is recommended to reduce thread trash in elastic configurations with dynamically increasing and decreasing concurrent consumers. One of: [ThreadPool] [SimpleAsync]";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DEFAULT_TASK_EXECUTOR_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EAGER_LOADING_OF_PROPERTIES_CONF = "camel.component.amqp.eagerLoadingOfProperties";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EAGER_LOADING_OF_PROPERTIES_DOC = "Enables eager loading of JMS properties and payload as soon as a message is loaded which generally is inefficient as the JMS properties may not be required but sometimes can catch early any issues with the underlying JMS provider and the use of JMS properties. See also the option eagerPoisonBody.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_EAGER_LOADING_OF_PROPERTIES_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EAGER_POISON_BODY_CONF = "camel.component.amqp.eagerPoisonBody";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EAGER_POISON_BODY_DOC = "If eagerLoadingOfProperties is enabled and the JMS message payload (JMS body or JMS properties) is poison (cannot be read/mapped), then set this text as the message body instead so the message can be processed (the cause of the poison are already stored as exception on the Exchange). This can be turned off by setting eagerPoisonBody=false. See also the option eagerLoadingOfProperties.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EAGER_POISON_BODY_DEFAULT = "Poison JMS message due to ${exception.message}";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EXPOSE_LISTENER_SESSION_CONF = "camel.component.amqp.exposeListenerSession";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EXPOSE_LISTENER_SESSION_DOC = "Specifies whether the listener session should be exposed when consuming messages.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_EXPOSE_LISTENER_SESSION_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_SAME_DESTINATION_ALLOWED_CONF = "camel.component.amqp.replyToSameDestinationAllowed";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_SAME_DESTINATION_ALLOWED_DOC = "Whether a JMS consumer is allowed to send a reply message to the same destination that the consumer is using to consume from. This prevents an endless loop by consuming and sending back the same message to itself.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_SAME_DESTINATION_ALLOWED_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TASK_EXECUTOR_CONF = "camel.component.amqp.taskExecutor";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TASK_EXECUTOR_DOC = "Allows you to specify a custom task executor for consuming messages.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TASK_EXECUTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_CONNECTION_FACTORY_CONF = "camel.component.amqp.allowAutoWiredConnectionFactory";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_CONNECTION_FACTORY_DOC = "Whether to auto-discover ConnectionFactory from the registry, if no connection factory has been configured. If only one instance of ConnectionFactory is found then it will be used. This is enabled by default.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_CONNECTION_FACTORY_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_DESTINATION_RESOLVER_CONF = "camel.component.amqp.allowAutoWiredDestinationResolver";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_DESTINATION_RESOLVER_DOC = "Whether to auto-discover DestinationResolver from the registry, if no destination resolver has been configured. If only one instance of DestinationResolver is found then it will be used. This is enabled by default.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_DESTINATION_RESOLVER_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_SERIALIZED_HEADERS_CONF = "camel.component.amqp.allowSerializedHeaders";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_SERIALIZED_HEADERS_DOC = "Controls whether or not to include serialized headers. Applies only when transferExchange is true. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_SERIALIZED_HEADERS_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ARTEMIS_STREAMING_ENABLED_CONF = "camel.component.amqp.artemisStreamingEnabled";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ARTEMIS_STREAMING_ENABLED_DOC = "Whether optimizing for Apache Artemis streaming mode.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ARTEMIS_STREAMING_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_START_LISTENER_CONF = "camel.component.amqp.asyncStartListener";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_START_LISTENER_DOC = "Whether to startup the JmsConsumer message listener asynchronously, when starting a route. For example if a JmsConsumer cannot get a connection to a remote JMS broker, then it may block while retrying and/or failover. This will cause Camel to block while starting routes. By setting this option to true, you will let routes startup, while the JmsConsumer connects to the JMS broker using a dedicated thread in asynchronous mode. If this option is used, then beware that if the connection could not be established, then an exception is logged at WARN level, and the consumer will not be able to receive messages; You can then restart the route to retry.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_START_LISTENER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_STOP_LISTENER_CONF = "camel.component.amqp.asyncStopListener";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_STOP_LISTENER_DOC = "Whether to stop the JmsConsumer message listener asynchronously, when stopping a route.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_STOP_LISTENER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.amqp.basicPropertyBinding";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONFIGURATION_CONF = "camel.component.amqp.configuration";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONFIGURATION_DOC = "To use a shared JMS configuration";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DESTINATION_RESOLVER_CONF = "camel.component.amqp.destinationResolver";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DESTINATION_RESOLVER_DOC = "A pluggable org.springframework.jms.support.destination.DestinationResolver that allows you to use your own resolver (for example, to lookup the real destination in a JNDI registry).";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_DESTINATION_RESOLVER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_CONF = "camel.component.amqp.errorHandler";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_DOC = "Specifies a org.springframework.util.ErrorHandler to be invoked in case of any uncaught exceptions thrown while processing a Message. By default these exceptions will be logged at the WARN level, if no errorHandler has been configured. You can configure logging level and whether stack traces should be logged using errorHandlerLoggingLevel and errorHandlerLogStackTrace options. This makes it much easier to configure, than having to code a custom errorHandler.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EXCEPTION_LISTENER_CONF = "camel.component.amqp.exceptionListener";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EXCEPTION_LISTENER_DOC = "Specifies the JMS Exception Listener that is to be notified of any underlying JMS exceptions.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_EXCEPTION_LISTENER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_IDLE_CONSUMER_LIMIT_CONF = "camel.component.amqp.idleConsumerLimit";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_IDLE_CONSUMER_LIMIT_DOC = "Specify the limit for the number of consumers that are allowed to be idle at any given time.";
    public static final Integer CAMEL_SOURCE_AMQP_COMPONENT_IDLE_CONSUMER_LIMIT_DEFAULT = 1;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_IDLE_TASK_EXECUTION_LIMIT_CONF = "camel.component.amqp.idleTaskExecutionLimit";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_IDLE_TASK_EXECUTION_LIMIT_DOC = "Specifies the limit for idle executions of a receive task, not having received any message within its execution. If this limit is reached, the task will shut down and leave receiving to other executing tasks (in the case of dynamic scheduling; see the maxConcurrentConsumers setting). There is additional doc available from Spring.";
    public static final Integer CAMEL_SOURCE_AMQP_COMPONENT_IDLE_TASK_EXECUTION_LIMIT_DEFAULT = 1;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_ALL_JMSXPROPERTIES_CONF = "camel.component.amqp.includeAllJMSXProperties";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_ALL_JMSXPROPERTIES_DOC = "Whether to include all JMSXxxx properties when mapping from JMS to Camel Message. Setting this to true will include properties such as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom headerFilterStrategy then this option does not apply.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_ALL_JMSXPROPERTIES_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_JMS_KEY_FORMAT_STRATEGY_CONF = "camel.component.amqp.jmsKeyFormatStrategy";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_JMS_KEY_FORMAT_STRATEGY_DOC = "Pluggable strategy for encoding and decoding JMS keys so they can be compliant with the JMS specification. Camel provides two implementations out of the box: default and passthrough. The default strategy will safely marshal dots and hyphens (. and -). The passthrough strategy leaves the key as is. Can be used for JMS brokers which do not care whether JMS header keys contain illegal characters. You can provide your own implementation of the org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it using the # notation. One of: [default] [passthrough]";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_JMS_KEY_FORMAT_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MAP_JMS_MESSAGE_CONF = "camel.component.amqp.mapJmsMessage";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MAP_JMS_MESSAGE_DOC = "Specifies whether Camel should auto map the received JMS message to a suited payload type, such as javax.jms.TextMessage to a String etc.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_MAP_JMS_MESSAGE_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MAX_MESSAGES_PER_TASK_CONF = "camel.component.amqp.maxMessagesPerTask";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MAX_MESSAGES_PER_TASK_DOC = "The number of messages per task. -1 is unlimited. If you use a range for concurrent consumers (eg min max), then this option can be used to set a value to eg 100 to control how fast the consumers will shrink when less work is required.";
    public static final Integer CAMEL_SOURCE_AMQP_COMPONENT_MAX_MESSAGES_PER_TASK_DEFAULT = -1;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CONVERTER_CONF = "camel.component.amqp.messageConverter";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CONVERTER_DOC = "To use a custom Spring org.springframework.jms.support.converter.MessageConverter so you can be in control how to map to/from a javax.jms.Message.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CONVERTER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CREATED_STRATEGY_CONF = "camel.component.amqp.messageCreatedStrategy";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CREATED_STRATEGY_DOC = "To use the given MessageCreatedStrategy which are invoked when Camel creates new instances of javax.jms.Message objects when Camel is sending a JMS message.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CREATED_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_ID_ENABLED_CONF = "camel.component.amqp.messageIdEnabled";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_ID_ENABLED_DOC = "When sending, specifies whether message IDs should be added. This is just an hint to the JMS broker. If the JMS provider accepts this hint, these messages must have the message ID set to null; if the provider ignores the hint, the message ID must be set to its normal unique value.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_ID_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_LISTENER_CONTAINER_FACTORY_CONF = "camel.component.amqp.messageListenerContainerFactory";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_LISTENER_CONTAINER_FACTORY_DOC = "Registry ID of the MessageListenerContainerFactory used to determine what org.springframework.jms.listener.AbstractMessageListenerContainer to use to consume messages. Setting this will automatically set consumerType to Custom.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_LISTENER_CONTAINER_FACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_TIMESTAMP_ENABLED_CONF = "camel.component.amqp.messageTimestampEnabled";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_TIMESTAMP_ENABLED_DOC = "Specifies whether timestamps should be enabled by default on sending messages. This is just an hint to the JMS broker. If the JMS provider accepts this hint, these messages must have the timestamp set to zero; if the provider ignores the hint the timestamp must be set to its normal value.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_TIMESTAMP_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_PUB_SUB_NO_LOCAL_CONF = "camel.component.amqp.pubSubNoLocal";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_PUB_SUB_NO_LOCAL_DOC = "Specifies whether to inhibit the delivery of messages published by its own connection.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_PUB_SUB_NO_LOCAL_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_QUEUE_BROWSE_STRATEGY_CONF = "camel.component.amqp.queueBrowseStrategy";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_QUEUE_BROWSE_STRATEGY_DOC = "To use a custom QueueBrowseStrategy when browsing queues";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_QUEUE_BROWSE_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_RECEIVE_TIMEOUT_CONF = "camel.component.amqp.receiveTimeout";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_RECEIVE_TIMEOUT_DOC = "The timeout for receiving messages (in milliseconds).";
    public static final Long CAMEL_SOURCE_AMQP_COMPONENT_RECEIVE_TIMEOUT_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_RECOVERY_INTERVAL_CONF = "camel.component.amqp.recoveryInterval";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_RECOVERY_INTERVAL_DOC = "Specifies the interval between recovery attempts, i.e. when a connection is being refreshed, in milliseconds. The default is 5000 ms, that is, 5 seconds.";
    public static final Long CAMEL_SOURCE_AMQP_COMPONENT_RECOVERY_INTERVAL_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF = "camel.component.amqp.requestTimeoutCheckerInterval";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC = "Configures how often Camel should check for timed out Exchanges when doing request/reply over JMS. By default Camel checks once per second. But if you must react faster when a timeout occurs, then you can lower this interval, to check more frequently. The timeout is determined by the option requestTimeout.";
    public static final Long CAMEL_SOURCE_AMQP_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCEPTION_CONF = "camel.component.amqp.transferException";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCEPTION_DOC = "If enabled and you are using Request Reply messaging (InOut) and an Exchange failed on the consumer side, then the caused Exception will be send back in response as a javax.jms.ObjectMessage. If the client is Camel, the returned Exception is rethrown. This allows you to use Camel JMS as a bridge in your routing - for example, using persistent queues to enable robust routing. Notice that if you also have transferExchange enabled, this option takes precedence. The caught exception is required to be serializable. The original Exception on the consumer side can be wrapped in an outer exception such as org.apache.camel.RuntimeCamelException when returned to the producer. Use this with caution as the data is using Java Object serialization and requires the received to be able to deserialize the data at Class level, which forces a strong coupling between the producers and consumer!";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCEPTION_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCHANGE_CONF = "camel.component.amqp.transferExchange";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCHANGE_DOC = "You can transfer the exchange over the wire instead of just the body and headers. The following fields are transferred: In body, Out body, Fault body, In headers, Out headers, Fault headers, exchange properties, exchange exception. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level. You must enable this option on both the producer and consumer side, so Camel knows the payloads is an Exchange and not a regular payload. Use this with caution as the data is using Java Object serialization and requires the received to be able to deserialize the data at Class level, which forces a strong coupling between the producers and consumer having to use compatible Camel versions!";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCHANGE_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_USE_MESSAGE_IDAS_CORRELATION_IDCONF = "camel.component.amqp.useMessageIDAsCorrelationID";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_USE_MESSAGE_IDAS_CORRELATION_IDDOC = "Specifies whether JMSMessageID should always be used as JMSCorrelationID for InOut messages.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_USE_MESSAGE_IDAS_CORRELATION_IDDEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_CONF = "camel.component.amqp.waitForProvisionCorrelationToBeUpdatedCounter";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_DOC = "Number of times to wait for provisional correlation id to be updated to the actual correlation id when doing request/reply over JMS and when the option useMessageIDAsCorrelationID is enabled.";
    public static final Integer CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_DEFAULT = 50;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_CONF = "camel.component.amqp.waitForProvisionCorrelationToBeUpdatedThreadSleepingTime";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_DOC = "Interval in millis to sleep each time while waiting for provisional correlation id to be updated.";
    public static final Long CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_DEFAULT = 100L;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_HEADER_FILTER_STRATEGY_CONF = "camel.component.amqp.headerFilterStrategy";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_HEADER_FILTER_STRATEGY_DOC = "To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOGGING_LEVEL_CONF = "camel.component.amqp.errorHandlerLoggingLevel";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOGGING_LEVEL_DOC = "Allows to configure the default errorHandler logging level for logging uncaught exceptions. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOGGING_LEVEL_DEFAULT = "WARN";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOG_STACK_TRACE_CONF = "camel.component.amqp.errorHandlerLogStackTrace";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOG_STACK_TRACE_DOC = "Allows to control whether stacktraces should be logged or not, by the default errorHandler.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOG_STACK_TRACE_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_PASSWORD_CONF = "camel.component.amqp.password";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_PASSWORD_DOC = "Password to use with the ConnectionFactory. You can also configure username/password directly on the ConnectionFactory.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_USERNAME_CONF = "camel.component.amqp.username";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_USERNAME_DOC = "Username to use with the ConnectionFactory. You can also configure username/password directly on the ConnectionFactory.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTED_CONF = "camel.component.amqp.transacted";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTED_DOC = "Specifies whether to use transacted mode";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTED_DEFAULT = false;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_LAZY_CREATE_TRANSACTION_MANAGER_CONF = "camel.component.amqp.lazyCreateTransactionManager";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_LAZY_CREATE_TRANSACTION_MANAGER_DOC = "If true, Camel will create a JmsTransactionManager, if there is no transactionManager injected when option transacted=true.";
    public static final Boolean CAMEL_SOURCE_AMQP_COMPONENT_LAZY_CREATE_TRANSACTION_MANAGER_DEFAULT = true;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_MANAGER_CONF = "camel.component.amqp.transactionManager";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_MANAGER_DOC = "The Spring transaction manager to use.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_MANAGER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_NAME_CONF = "camel.component.amqp.transactionName";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_NAME_DOC = "The name of the transaction to use.";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_TIMEOUT_CONF = "camel.component.amqp.transactionTimeout";
    public static final String CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_TIMEOUT_DOC = "The timeout value of the transaction (in seconds), if using transacted mode.";
    public static final Integer CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_TIMEOUT_DEFAULT = -1;

    public CamelAmqpSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAmqpSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_AMQP_PATH_DESTINATION_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_PATH_DESTINATION_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_PATH_DESTINATION_TYPE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_PATH_DESTINATION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_PATH_DESTINATION_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_AMQP_PATH_DESTINATION_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_CLIENT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_CLIENT_ID_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_CONNECTION_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_DISABLE_REPLY_TO_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_DISABLE_REPLY_TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_DISABLE_REPLY_TO_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_DURABLE_SUBSCRIPTION_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_JMS_MESSAGE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_JMS_MESSAGE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_JMS_MESSAGE_TYPE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_TEST_CONNECTION_ON_STARTUP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ACKNOWLEDGEMENT_MODE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_ACKNOWLEDGEMENT_MODE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ACKNOWLEDGEMENT_MODE_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_CONSUMER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_CONSUMER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_CONSUMER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_AUTO_STARTUP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_AUTO_STARTUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_AUTO_STARTUP_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_CACHE_LEVEL_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_MAX_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_ENDPOINT_MAX_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_MAX_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_DELIVERY_PERSISTENT_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_SELECTOR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_SELECTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_SELECTOR_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_DURABLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_DURABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_DURABLE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_SHARED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_SHARED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_SUBSCRIPTION_SHARED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ACCEPT_MESSAGES_WHILE_STOPPING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_ACCEPT_MESSAGES_WHILE_STOPPING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ACCEPT_MESSAGES_WHILE_STOPPING_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_REPLY_MANAGER_QUICK_STOP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_REPLY_MANAGER_QUICK_STOP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_REPLY_MANAGER_QUICK_STOP_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_CONSUMER_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_CONSUMER_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_CONSUMER_TYPE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_DEFAULT_TASK_EXECUTOR_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_DEFAULT_TASK_EXECUTOR_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_DEFAULT_TASK_EXECUTOR_TYPE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_LOADING_OF_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_POISON_BODY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_POISON_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_EAGER_POISON_BODY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_EXPOSE_LISTENER_SESSION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_EXPOSE_LISTENER_SESSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_EXPOSE_LISTENER_SESSION_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_REPLY_TO_SAME_DESTINATION_ALLOWED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_TASK_EXECUTOR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_TASK_EXECUTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_TASK_EXECUTOR_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_SERIALIZED_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ALLOW_SERIALIZED_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ARTEMIS_STREAMING_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_ARTEMIS_STREAMING_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ARTEMIS_STREAMING_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_START_LISTENER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_START_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_START_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_STOP_LISTENER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_STOP_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ASYNC_STOP_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_DESTINATION_RESOLVER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_DESTINATION_RESOLVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_DESTINATION_RESOLVER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_LISTENER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_EXCEPTION_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_HEADER_FILTER_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_CONSUMER_LIMIT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_CONSUMER_LIMIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_CONSUMER_LIMIT_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_TASK_EXECUTION_LIMIT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_TASK_EXECUTION_LIMIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_IDLE_TASK_EXECUTION_LIMIT_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_INCLUDE_ALL_JMSXPROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_JMS_KEY_FORMAT_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_MAP_JMS_MESSAGE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_MAP_JMS_MESSAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_MAP_JMS_MESSAGE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_MAX_MESSAGES_PER_TASK_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_ENDPOINT_MAX_MESSAGES_PER_TASK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_MAX_MESSAGES_PER_TASK_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CREATED_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CREATED_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_CREATED_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_ID_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_ID_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_ID_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_LISTENER_CONTAINER_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_LISTENER_CONTAINER_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_LISTENER_CONTAINER_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_TIMESTAMP_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_TIMESTAMP_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_MESSAGE_TIMESTAMP_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_PUB_SUB_NO_LOCAL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_PUB_SUB_NO_LOCAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_PUB_SUB_NO_LOCAL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_RECEIVE_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AMQP_ENDPOINT_RECEIVE_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_RECEIVE_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_RECOVERY_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AMQP_ENDPOINT_RECOVERY_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_RECOVERY_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AMQP_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCEPTION_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCHANGE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCHANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSFER_EXCHANGE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_USE_MESSAGE_IDAS_CORRELATION_IDCONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_USE_MESSAGE_IDAS_CORRELATION_IDDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_USE_MESSAGE_IDAS_CORRELATION_IDDOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOGGING_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOGGING_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOGGING_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOG_STACK_TRACE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOG_STACK_TRACE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_ERROR_HANDLER_LOG_STACK_TRACE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_LAZY_CREATE_TRANSACTION_MANAGER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_ENDPOINT_LAZY_CREATE_TRANSACTION_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_LAZY_CREATE_TRANSACTION_MANAGER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_MANAGER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_ENDPOINT_TRANSACTION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_CLIENT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_CLIENT_ID_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_CONNECTION_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_DISABLE_REPLY_TO_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_DISABLE_REPLY_TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_DISABLE_REPLY_TO_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_DURABLE_SUBSCRIPTION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_DURABLE_SUBSCRIPTION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_DURABLE_SUBSCRIPTION_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_AMQP_ANNOTATIONS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_AMQP_ANNOTATIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_AMQP_ANNOTATIONS_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_JMS_MESSAGE_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_JMS_MESSAGE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_JMS_MESSAGE_TYPE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_TEST_CONNECTION_ON_STARTUP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_TEST_CONNECTION_ON_STARTUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_TEST_CONNECTION_ON_STARTUP_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ACKNOWLEDGEMENT_MODE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_ACKNOWLEDGEMENT_MODE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ACKNOWLEDGEMENT_MODE_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_CONSUMER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_CONSUMER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_CONSUMER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_AUTO_STARTUP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_AUTO_STARTUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_AUTO_STARTUP_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_CACHE_LEVEL_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_COMPONENT_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_MAX_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_COMPONENT_MAX_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_MAX_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DELIVERY_PERSISTENT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DELIVERY_PERSISTENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_DELIVERY_PERSISTENT_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_SELECTOR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_SELECTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_SELECTOR_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_DURABLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_DURABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_DURABLE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_SHARED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_SHARED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_SUBSCRIPTION_SHARED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ACCEPT_MESSAGES_WHILE_STOPPING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ACCEPT_MESSAGES_WHILE_STOPPING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ACCEPT_MESSAGES_WHILE_STOPPING_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_REPLY_MANAGER_QUICK_STOP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_REPLY_MANAGER_QUICK_STOP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_REPLY_MANAGER_QUICK_STOP_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_CONSUMER_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_CONSUMER_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_CONSUMER_TYPE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_DEFAULT_TASK_EXECUTOR_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_DEFAULT_TASK_EXECUTOR_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_DEFAULT_TASK_EXECUTOR_TYPE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_EAGER_LOADING_OF_PROPERTIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_EAGER_LOADING_OF_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_EAGER_LOADING_OF_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_EAGER_POISON_BODY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_EAGER_POISON_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_EAGER_POISON_BODY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_EXPOSE_LISTENER_SESSION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_EXPOSE_LISTENER_SESSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_EXPOSE_LISTENER_SESSION_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_SAME_DESTINATION_ALLOWED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_SAME_DESTINATION_ALLOWED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_REPLY_TO_SAME_DESTINATION_ALLOWED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_TASK_EXECUTOR_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_TASK_EXECUTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_TASK_EXECUTOR_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_CONNECTION_FACTORY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_CONNECTION_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_CONNECTION_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_DESTINATION_RESOLVER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_DESTINATION_RESOLVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_AUTO_WIRED_DESTINATION_RESOLVER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_SERIALIZED_HEADERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_SERIALIZED_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ALLOW_SERIALIZED_HEADERS_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ARTEMIS_STREAMING_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ARTEMIS_STREAMING_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ARTEMIS_STREAMING_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_START_LISTENER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_START_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_START_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_STOP_LISTENER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_STOP_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ASYNC_STOP_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_DESTINATION_RESOLVER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_DESTINATION_RESOLVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_DESTINATION_RESOLVER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_EXCEPTION_LISTENER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_EXCEPTION_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_EXCEPTION_LISTENER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_IDLE_CONSUMER_LIMIT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_COMPONENT_IDLE_CONSUMER_LIMIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_IDLE_CONSUMER_LIMIT_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_IDLE_TASK_EXECUTION_LIMIT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_COMPONENT_IDLE_TASK_EXECUTION_LIMIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_IDLE_TASK_EXECUTION_LIMIT_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_ALL_JMSXPROPERTIES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_ALL_JMSXPROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_INCLUDE_ALL_JMSXPROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_JMS_KEY_FORMAT_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_JMS_KEY_FORMAT_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_JMS_KEY_FORMAT_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_MAP_JMS_MESSAGE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_MAP_JMS_MESSAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_MAP_JMS_MESSAGE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_MAX_MESSAGES_PER_TASK_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_COMPONENT_MAX_MESSAGES_PER_TASK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_MAX_MESSAGES_PER_TASK_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CREATED_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CREATED_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_CREATED_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_ID_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_ID_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_ID_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_LISTENER_CONTAINER_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_LISTENER_CONTAINER_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_LISTENER_CONTAINER_FACTORY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_TIMESTAMP_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_TIMESTAMP_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_MESSAGE_TIMESTAMP_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_PUB_SUB_NO_LOCAL_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_PUB_SUB_NO_LOCAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_PUB_SUB_NO_LOCAL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_QUEUE_BROWSE_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_QUEUE_BROWSE_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_QUEUE_BROWSE_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_RECEIVE_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AMQP_COMPONENT_RECEIVE_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_RECEIVE_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_RECOVERY_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AMQP_COMPONENT_RECOVERY_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_RECOVERY_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AMQP_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_REQUEST_TIMEOUT_CHECKER_INTERVAL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCEPTION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCEPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCEPTION_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCHANGE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCHANGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_TRANSFER_EXCHANGE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_USE_MESSAGE_IDAS_CORRELATION_IDCONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_USE_MESSAGE_IDAS_CORRELATION_IDDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_USE_MESSAGE_IDAS_CORRELATION_IDDOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_COUNTER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_WAIT_FOR_PROVISION_CORRELATION_TO_BE_UPDATED_THREAD_SLEEPING_TIME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_HEADER_FILTER_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOGGING_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOGGING_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOGGING_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOG_STACK_TRACE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOG_STACK_TRACE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_ERROR_HANDLER_LOG_STACK_TRACE_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTED_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_LAZY_CREATE_TRANSACTION_MANAGER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AMQP_COMPONENT_LAZY_CREATE_TRANSACTION_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_LAZY_CREATE_TRANSACTION_MANAGER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_MANAGER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_MANAGER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_MANAGER_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_NAME_DOC);
        conf.define(CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AMQP_COMPONENT_TRANSACTION_TIMEOUT_DOC);
        return conf;
    }
}