/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsHeaderFilterStrategy;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.StreamMessageInputStream;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class JmsBinding {
    private static final Logger LOG = LoggerFactory.getLogger(JmsBinding.class);
    private final JmsEndpoint endpoint;
    private final HeaderFilterStrategy headerFilterStrategy;
    private final JmsKeyFormatStrategy jmsKeyFormatStrategy;
    private final MessageCreatedStrategy messageCreatedStrategy;

    public JmsBinding() {
        this.endpoint = null;
        this.headerFilterStrategy = new JmsHeaderFilterStrategy(false);
        this.jmsKeyFormatStrategy = new DefaultJmsKeyFormatStrategy();
        this.messageCreatedStrategy = null;
    }

    public JmsBinding(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
        this.headerFilterStrategy = endpoint.getHeaderFilterStrategy() != null ? endpoint.getHeaderFilterStrategy() : new JmsHeaderFilterStrategy(endpoint.isIncludeAllJMSXProperties());
        this.jmsKeyFormatStrategy = endpoint.getJmsKeyFormatStrategy() != null ? endpoint.getJmsKeyFormatStrategy() : new DefaultJmsKeyFormatStrategy();
        this.messageCreatedStrategy = endpoint.getMessageCreatedStrategy() != null ? endpoint.getMessageCreatedStrategy() : (endpoint.getComponent() != null ? endpoint.getComponent().getConfiguration().getMessageCreatedStrategy() : null);
    }

    public Object extractBodyFromJms(Exchange exchange, javax.jms.Message message) {
        try {
            if (this.endpoint != null && this.endpoint.getMessageConverter() != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Extracting body using a custom MessageConverter: {} from JMS message: {}", (Object)this.endpoint.getMessageConverter(), (Object)message);
                }
                return this.endpoint.getMessageConverter().fromMessage(message);
            }
            if (this.endpoint != null && !this.endpoint.getConfiguration().isMapJmsMessage()) {
                LOG.trace("Option map JMS message is false so using JMS message as body: {}", (Object)message);
                return message;
            }
            if (message instanceof ObjectMessage) {
                LOG.trace("Extracting body as a ObjectMessage from JMS message: {}", (Object)message);
                ObjectMessage objectMessage = (ObjectMessage)message;
                Serializable payload = objectMessage.getObject();
                if (payload instanceof DefaultExchangeHolder) {
                    DefaultExchangeHolder holder = (DefaultExchangeHolder)payload;
                    DefaultExchangeHolder.unmarshal((Exchange)exchange, (DefaultExchangeHolder)holder);
                    Map<String, Object> jmsHeaders = this.extractHeadersFromJms(message, exchange);
                    exchange.getIn().getHeaders().putAll(jmsHeaders);
                    return exchange.getIn().getBody();
                }
                return objectMessage.getObject();
            }
            if (message instanceof TextMessage) {
                LOG.trace("Extracting body as a TextMessage from JMS message: {}", (Object)message);
                TextMessage textMessage = (TextMessage)message;
                return textMessage.getText();
            }
            if (message instanceof MapMessage) {
                LOG.trace("Extracting body as a MapMessage from JMS message: {}", (Object)message);
                return this.createMapFromMapMessage((MapMessage)message);
            }
            if (message instanceof BytesMessage) {
                LOG.trace("Extracting body as a BytesMessage from JMS message: {}", (Object)message);
                return this.createByteArrayFromBytesMessage(exchange, (BytesMessage)message);
            }
            if (message instanceof StreamMessage) {
                LOG.trace("Extracting body as a StreamMessage from JMS message: {}", (Object)message);
                StreamMessage streamMessage = (StreamMessage)message;
                return this.createInputStreamFromStreamMessage(exchange, streamMessage);
            }
            return null;
        }
        catch (JMSException e) {
            throw new RuntimeCamelException("Failed to extract body due to: " + (Object)((Object)e) + ". Message: " + message, (Throwable)e);
        }
    }

    public Map<String, Object> extractHeadersFromJms(javax.jms.Message jmsMessage, Exchange exchange) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (jmsMessage != null) {
            Enumeration names;
            try {
                map.put("JMSCorrelationID", jmsMessage.getJMSCorrelationID());
                map.put("JMSCorrelationIDAsBytes", JmsMessageHelper.getJMSCorrelationIDAsBytes(jmsMessage));
                map.put("JMSDeliveryMode", jmsMessage.getJMSDeliveryMode());
                map.put("JMSDestination", jmsMessage.getJMSDestination());
                map.put("JMSExpiration", jmsMessage.getJMSExpiration());
                map.put("JMSMessageID", jmsMessage.getJMSMessageID());
                map.put("JMSPriority", jmsMessage.getJMSPriority());
                map.put("JMSRedelivered", jmsMessage.getJMSRedelivered());
                map.put("JMSTimestamp", jmsMessage.getJMSTimestamp());
                map.put("JMSReplyTo", JmsMessageHelper.getJMSReplyTo(jmsMessage));
                map.put("JMSType", JmsMessageHelper.getJMSType(jmsMessage));
                map.put("JMSXGroupID", JmsMessageHelper.getStringProperty(jmsMessage, "JMSXGroupID"));
                map.put("JMSXUserID", JmsMessageHelper.getStringProperty(jmsMessage, "JMSXUserID"));
            }
            catch (JMSException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            try {
                names = jmsMessage.getPropertyNames();
            }
            catch (JMSException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                try {
                    Object value = JmsMessageHelper.getProperty(jmsMessage, name);
                    if (this.headerFilterStrategy != null && this.headerFilterStrategy.applyFilterToExternalHeaders(name, value, exchange)) continue;
                    String key = this.jmsKeyFormatStrategy.decodeKey(name);
                    map.put(key, value);
                }
                catch (JMSException e) {
                    throw new RuntimeCamelException(name, (Throwable)e);
                }
            }
        }
        return map;
    }

    @Deprecated
    public Object getObjectProperty(javax.jms.Message jmsMessage, String name) throws JMSException {
        Object answer = jmsMessage.getObjectProperty(name);
        if (answer == null) {
            String key = this.jmsKeyFormatStrategy.encodeKey(name);
            answer = jmsMessage.getObjectProperty(key);
        }
        return answer;
    }

    protected Object createByteArrayFromBytesMessage(Exchange exchange, BytesMessage message) throws JMSException {
        Long size;
        boolean artemis = this.endpoint != null && this.endpoint.isArtemisStreamingEnabled();
        Long l = size = artemis ? JmsMessageHelper.getSafeLongProperty((javax.jms.Message)message, "_AMQ_LARGE_SIZE") : null;
        if (size != null && size > 0L) {
            LOG.trace("Optimised for Artemis: Reading from BytesMessage in streaming mode directly into CachedOutputStream payload");
            CachedOutputStream cos = new CachedOutputStream(exchange, true);
            message.setObjectProperty("JMS_AMQ_SaveStream", (Object)cos);
            try {
                InputStream inputStream = cos.getInputStream();
                return inputStream;
            }
            catch (IOException e) {
                MessageFormatException cause = new MessageFormatException(e.getMessage());
                cause.initCause((Throwable)e);
                throw cause;
            }
            finally {
                IOHelper.close((Closeable)cos);
            }
        }
        if (message.getBodyLength() > Integer.MAX_VALUE) {
            LOG.warn("Length of BytesMessage is too long: {}", (Object)message.getBodyLength());
            return null;
        }
        byte[] result = new byte[(int)message.getBodyLength()];
        message.readBytes(result);
        return result;
    }

    protected Object createInputStreamFromStreamMessage(Exchange exchange, StreamMessage message) throws JMSException {
        return new StreamMessageInputStream(message);
    }

    public javax.jms.Message makeJmsMessage(Exchange exchange, Session session) throws JMSException {
        javax.jms.Message answer = this.makeJmsMessage(exchange, exchange.getIn(), session, null);
        if (answer != null && this.messageCreatedStrategy != null) {
            this.messageCreatedStrategy.onMessageCreated(answer, session, exchange, null);
        }
        return answer;
    }

    public javax.jms.Message makeJmsMessage(Exchange exchange, Message camelMessage, Session session, Exception cause) throws JMSException {
        JmsMessage jmsMessage;
        boolean force;
        javax.jms.Message answer = null;
        boolean alwaysCopy = this.endpoint != null && this.endpoint.getConfiguration().isAlwaysCopyMessage();
        boolean bl = force = this.endpoint != null && this.endpoint.getConfiguration().isForceSendOriginalMessage();
        if (!alwaysCopy && camelMessage instanceof JmsMessage && (!(jmsMessage = (JmsMessage)camelMessage).shouldCreateNewMessage() || force)) {
            answer = jmsMessage.getJmsMessage();
            if (!force) {
                JmsMessageType type;
                JmsMessageType jmsMessageType = type = this.endpoint != null ? this.endpoint.getConfiguration().getJmsMessageType() : null;
                if (type != null && answer != null) {
                    if (type == JmsMessageType.Text) {
                        answer = answer instanceof TextMessage ? answer : null;
                    } else if (type == JmsMessageType.Bytes) {
                        answer = answer instanceof BytesMessage ? answer : null;
                    } else if (type == JmsMessageType.Map) {
                        answer = answer instanceof MapMessage ? answer : null;
                    } else if (type == JmsMessageType.Object) {
                        answer = answer instanceof ObjectMessage ? answer : null;
                    } else if (type == JmsMessageType.Stream) {
                        Object object = answer = answer instanceof StreamMessage ? answer : null;
                    }
                }
            }
        }
        if (answer == null) {
            if (cause != null) {
                LOG.debug("Will create JmsMessage with caused exception: {}", (Object)cause.getMessage(), (Object)cause);
                answer = this.createJmsMessage(cause, session);
            } else {
                org.apache.camel.util.ObjectHelper.notNull((Object)camelMessage, (String)"message");
                answer = this.createJmsMessage(exchange, camelMessage, session, exchange.getContext());
                this.appendJmsProperties(answer, exchange, camelMessage);
            }
        }
        if (answer != null && this.messageCreatedStrategy != null) {
            this.messageCreatedStrategy.onMessageCreated(answer, session, exchange, null);
        }
        return answer;
    }

    public void appendJmsProperties(javax.jms.Message jmsMessage, Exchange exchange) throws JMSException {
        this.appendJmsProperties(jmsMessage, exchange, exchange.getIn());
    }

    public void appendJmsProperties(javax.jms.Message jmsMessage, Exchange exchange, Message in) throws JMSException {
        Set entries = in.getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            this.appendJmsProperty(jmsMessage, exchange, in, headerName, headerValue);
        }
    }

    public void appendJmsProperty(javax.jms.Message jmsMessage, Exchange exchange, Message in, String headerName, Object headerValue) throws JMSException {
        if (this.isStandardJMSHeader(headerName)) {
            if (headerName.equals("JMSCorrelationID") && (this.endpoint == null || !this.endpoint.isUseMessageIDAsCorrelationID())) {
                jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)headerValue));
            } else if (headerName.equals("JMSReplyTo") && headerValue != null) {
                if (headerValue instanceof String) {
                    headerValue = JmsMessageHelper.normalizeDestinationName((String)headerValue, true);
                }
                Destination replyTo = (Destination)ExchangeHelper.convertToType((Exchange)exchange, Destination.class, (Object)headerValue);
                JmsMessageHelper.setJMSReplyTo(jmsMessage, replyTo);
            } else if (headerName.equals("JMSType")) {
                jmsMessage.setJMSType((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)headerValue));
            } else if (headerName.equals("JMSPriority")) {
                jmsMessage.setJMSPriority(((Integer)ExchangeHelper.convertToType((Exchange)exchange, Integer.class, (Object)headerValue)).intValue());
            } else if (headerName.equals("JMSDeliveryMode")) {
                JmsMessageHelper.setJMSDeliveryMode(exchange, jmsMessage, headerValue);
            } else if (headerName.equals("JMSExpiration")) {
                jmsMessage.setJMSExpiration(((Long)ExchangeHelper.convertToType((Exchange)exchange, Long.class, (Object)headerValue)).longValue());
            } else {
                LOG.trace("Ignoring JMS header: {} with value: {}", (Object)headerName, headerValue);
            }
        } else if (this.shouldOutputHeader(in, headerName, headerValue, exchange)) {
            Object value = this.getValidJMSHeaderValue(headerName, headerValue);
            if (value == null && this.endpoint != null && this.endpoint.getConfiguration().getAllowAdditionalHeaders() != null) {
                Iterator it = ObjectHelper.createIterator((Object)this.endpoint.getConfiguration().getAllowAdditionalHeaders());
                while (it.hasNext()) {
                    String pattern = (String)it.next();
                    if (!PatternHelper.matchPattern((String)headerName, (String)pattern)) continue;
                    LOG.debug("Header {} allowed as additional header despite not being valid according to the JMS specification", (Object)headerName);
                    value = headerValue;
                    break;
                }
            }
            if (value != null) {
                String key = this.jmsKeyFormatStrategy.encodeKey(headerName);
                JmsMessageHelper.setProperty(jmsMessage, key, value);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring non primitive header: {} of class: {} with value: {}", new Object[]{headerName, headerValue.getClass().getName(), headerValue});
            }
        }
    }

    protected boolean isStandardJMSHeader(String headerName) {
        char fourth;
        if (!headerName.startsWith("JMS")) {
            return false;
        }
        if (headerName.startsWith("JMSX")) {
            return false;
        }
        if (headerName.startsWith("JMS_")) {
            return false;
        }
        return headerName.length() > 3 && Character.isLetter(fourth = headerName.charAt(3));
    }

    protected Object getValidJMSHeaderValue(String headerName, Object headerValue) {
        if (headerValue instanceof String) {
            return headerValue;
        }
        if (headerValue instanceof BigInteger) {
            return headerValue.toString();
        }
        if (headerValue instanceof BigDecimal) {
            return headerValue.toString();
        }
        if (headerValue instanceof Number) {
            return headerValue;
        }
        if (headerValue instanceof Character) {
            return headerValue;
        }
        if (headerValue instanceof CharSequence) {
            return headerValue.toString();
        }
        if (headerValue instanceof Boolean) {
            return headerValue;
        }
        if (headerValue instanceof Date) {
            if (this.endpoint.getConfiguration().isFormatDateHeadersToIso8601()) {
                return ZonedDateTime.ofInstant(((Date)headerValue).toInstant(), ZoneOffset.UTC).toString();
            }
            return headerValue.toString();
        }
        return null;
    }

    protected javax.jms.Message createJmsMessage(Exception cause, Session session) throws JMSException {
        LOG.trace("Using JmsMessageType: {}", (Object)JmsMessageType.Object);
        ObjectMessage answer = session.createObjectMessage((Serializable)cause);
        answer.setJMSDeliveryMode(2);
        return answer;
    }

    protected javax.jms.Message createJmsMessage(Exchange exchange, Message camelMessage, Session session, CamelContext context) throws JMSException {
        return this.createJmsMessage(exchange, camelMessage.getBody(), camelMessage.getHeaders(), session, context);
    }

    protected javax.jms.Message createJmsMessage(Exchange exchange, Object body, Map<String, Object> headers, Session session, CamelContext context) throws JMSException {
        if (this.endpoint != null && this.endpoint.isTransferExchange()) {
            LOG.trace("Option transferExchange=true so we use JmsMessageType: Object");
            DefaultExchangeHolder holder = DefaultExchangeHolder.marshal((Exchange)exchange, (boolean)true, (boolean)this.endpoint.isAllowSerializedHeaders(), (boolean)false);
            ObjectMessage answer = session.createObjectMessage((Serializable)holder);
            answer.setJMSDeliveryMode(2);
            return answer;
        }
        if (this.endpoint != null && this.endpoint.getMessageConverter() != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating JmsMessage using a custom MessageConverter: {} with body: {}", (Object)this.endpoint.getMessageConverter(), body);
            }
            return this.endpoint.getMessageConverter().toMessage(body, session);
        }
        JmsMessageType type = headers.containsKey("CamelJmsMessageType") ? (JmsMessageType)((Object)context.getTypeConverter().convertTo(JmsMessageType.class, headers.get("CamelJmsMessageType"))) : (this.endpoint != null && this.endpoint.getConfiguration().getJmsMessageType() != null ? this.endpoint.getConfiguration().getJmsMessageType() : this.getJMSMessageTypeForBody(exchange, body, headers, session, context));
        if (type != null) {
            if (body == null && this.endpoint != null && !this.endpoint.getConfiguration().isAllowNullBody()) {
                throw new JMSException("Cannot send message as message body is null, and option allowNullBody is false.");
            }
            LOG.trace("Using JmsMessageType: {}", (Object)type);
            javax.jms.Message answer = this.createJmsMessageForType(exchange, body, headers, session, context, type);
            answer.setJMSDeliveryMode(2);
            return answer;
        }
        if (body == null && this.endpoint != null && !this.endpoint.getConfiguration().isAllowNullBody()) {
            throw new JMSException("Cannot send message as message body is null, and option allowNullBody is false.");
        }
        if (body != null && LOG.isWarnEnabled()) {
            LOG.warn("Cannot determine specific JmsMessage type to use from body class. Will use generic JmsMessage. Body class: " + org.apache.camel.util.ObjectHelper.classCanonicalName((Object)body) + ". If you want to send a POJO then your class might need to implement java.io.Serializable, or you can force a specific type by setting the jmsMessageType option on the JMS endpoint.");
        }
        javax.jms.Message answer = session.createMessage();
        answer.setJMSDeliveryMode(2);
        return answer;
    }

    protected JmsMessageType getJMSMessageTypeForBody(Exchange exchange, Object body, Map<String, Object> headers, Session session, CamelContext context) {
        boolean streamingEnabled = this.endpoint.getConfiguration().isStreamMessageTypeEnabled();
        JmsMessageType type = null;
        if (body instanceof Node || body instanceof String) {
            type = JmsMessageType.Text;
        } else if (body instanceof byte[] || body instanceof ByteBuffer) {
            type = JmsMessageType.Bytes;
        } else if (body instanceof WrappedFile || body instanceof File || body instanceof Reader || body instanceof InputStream || body instanceof StreamCache) {
            type = streamingEnabled ? JmsMessageType.Stream : JmsMessageType.Bytes;
        } else if (body instanceof Map) {
            type = JmsMessageType.Map;
        } else if (body instanceof Serializable) {
            type = JmsMessageType.Object;
        } else if (exchange.getContext().getTypeConverter().tryConvertTo(File.class, body) != null || exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, body) != null) {
            JmsMessageType jmsMessageType = type = streamingEnabled ? JmsMessageType.Stream : JmsMessageType.Bytes;
        }
        if (type == JmsMessageType.Stream) {
            boolean artemis;
            boolean bl = artemis = this.endpoint.isArtemisStreamingEnabled() && JmsMessageHelper.isVendor(session, "Artemis");
            if (artemis) {
                type = JmsMessageType.Bytes;
            }
        }
        return type;
    }

    protected javax.jms.Message createJmsMessageForType(Exchange exchange, Object body, Map<String, Object> headers, Session session, CamelContext context, JmsMessageType type) throws JMSException {
        switch (type) {
            case Text: {
                TextMessage message = session.createTextMessage();
                if (body != null) {
                    String payload = (String)context.getTypeConverter().convertTo(String.class, exchange, body);
                    message.setText(payload);
                }
                return message;
            }
            case Bytes: {
                BytesMessage message = session.createBytesMessage();
                if (body != null) {
                    try {
                        if (this.endpoint.isArtemisStreamingEnabled() && JmsMessageHelper.isVendor(session, "Artemis")) {
                            LOG.trace("Optimised for Artemis: Streaming payload in BytesMessage");
                            InputStream is = (InputStream)context.getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
                            message.setObjectProperty("JMS_AMQ_InputStream", (Object)is);
                            LOG.trace("Optimised for Artemis: Finished streaming payload in BytesMessage");
                        } else {
                            byte[] payload = (byte[])context.getTypeConverter().mandatoryConvertTo(byte[].class, exchange, body);
                            message.writeBytes(payload);
                        }
                    }
                    catch (NoTypeConversionAvailableException e) {
                        MessageFormatException cause = new MessageFormatException(e.getMessage());
                        cause.initCause((Throwable)e);
                        throw cause;
                    }
                }
                return message;
            }
            case Map: {
                MapMessage message = session.createMapMessage();
                if (body != null) {
                    Map payload = (Map)context.getTypeConverter().convertTo(Map.class, exchange, body);
                    this.populateMapMessage(message, payload, context);
                }
                return message;
            }
            case Object: {
                ObjectMessage message = session.createObjectMessage();
                if (body != null) {
                    try {
                        Serializable payload = (Serializable)context.getTypeConverter().mandatoryConvertTo(Serializable.class, exchange, body);
                        message.setObject(payload);
                    }
                    catch (NoTypeConversionAvailableException e) {
                        MessageFormatException cause = new MessageFormatException(e.getMessage());
                        cause.initCause((Throwable)e);
                        throw cause;
                    }
                }
                return message;
            }
            case Stream: {
                StreamMessage message = session.createStreamMessage();
                if (body != null) {
                    long size = 0L;
                    try {
                        InputStream is = (InputStream)context.getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
                        LOG.trace("Writing payload in StreamMessage");
                        byte[] buffer = new byte[131072];
                        int len = 0;
                        int count = 0;
                        while (len >= 0) {
                            ++count;
                            len = is.read(buffer);
                            if (len < 0) continue;
                            size += (long)len;
                            LOG.trace("Writing payload chunk {} as bytes in StreamMessage", (Object)count);
                            message.writeBytes(buffer, 0, len);
                        }
                        LOG.trace("Finished writing payload (size {}) as bytes in StreamMessage", (Object)size);
                    }
                    catch (IOException | NoTypeConversionAvailableException e) {
                        MessageFormatException cause = new MessageFormatException(e.getMessage());
                        cause.initCause(e);
                        throw cause;
                    }
                }
                return message;
            }
        }
        return null;
    }

    protected void populateMapMessage(MapMessage message, Map<?, ?> map, CamelContext context) throws JMSException {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String keyString = (String)CamelContextHelper.convertTo((CamelContext)context, String.class, entry.getKey());
            if (keyString == null) continue;
            message.setObject(keyString, entry.getValue());
        }
    }

    public Map<String, Object> createMapFromMapMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Enumeration names = message.getMapNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            Object value = message.getObject(name);
            answer.put(name, value);
        }
        return answer;
    }

    protected boolean shouldOutputHeader(Message camelMessage, String headerName, Object headerValue, Exchange exchange) {
        return this.headerFilterStrategy == null || !this.headerFilterStrategy.applyFilterToCamelHeaders(headerName, headerValue, exchange);
    }
}

