/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.parser.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenDataAndLocationConsumer;
import com.worldturner.medeia.parser.JsonTokenDataKt;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.parser.jackson.JacksonTokenDataJsonGeneratorKt;
import com.worldturner.medeia.pointer.JsonPointer;
import com.worldturner.medeia.pointer.JsonPointerBuilder;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001VB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010#\u001a\u00020\u00012\b\u0010$\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\rH\u0016J\b\u0010'\u001a\u00020\u0001H\u0016J\b\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\rH\u0016J(\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u0002002\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016J\u0010\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020!H\u0016J\b\u00105\u001a\u00020\u0015H\u0016J\b\u00106\u001a\u00020\u0015H\u0016J\u0010\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u000209H\u0016J\u0010\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u0006H\u0016J\b\u0010:\u001a\u00020\u0015H\u0016J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=H\u0016J\u0012\u0010;\u001a\u00020\u00152\b\u0010<\u001a\u0004\u0018\u00010>H\u0016J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020?H\u0016J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020@H\u0016J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\rH\u0016J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020AH\u0016J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u0006H\u0016J\u0012\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\u0010\u0010G\u001a\u00020D2\u0006\u0010H\u001a\u00020IH\u0016J \u0010G\u001a\u00020D2\u0006\u0010J\u001a\u00020K2\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016J\u0010\u0010G\u001a\u00020D2\u0006\u0010J\u001a\u00020\u0006H\u0016J \u0010G\u001a\u00020D2\u0006\u0010J\u001a\u00020\u00062\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016J\"\u0010L\u001a\u00020D2\b\u0010J\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\r2\u0006\u0010M\u001a\u00020\rH\u0016J \u0010N\u001a\u00020D2\u0006\u0010J\u001a\u00020K2\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016J\u0010\u0010N\u001a\u00020D2\u0006\u0010J\u001a\u00020\u0006H\u0016J \u0010N\u001a\u00020D2\u0006\u0010J\u001a\u00020\u00062\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016J\b\u0010O\u001a\u00020\u0015H\u0016J\b\u0010P\u001a\u00020\u0015H\u0016J\u0010\u0010Q\u001a\u00020\u00152\u0006\u0010J\u001a\u000209H\u0016J \u0010Q\u001a\u00020\u00152\u0006\u0010J\u001a\u00020K2\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0016J\u0010\u0010Q\u001a\u00020\u00152\u0006\u0010J\u001a\u00020\u0006H\u0016J\u0010\u0010R\u001a\u00020D2\u0006\u0010S\u001a\u00020TH\u0016J \u0010U\u001a\u00020D2\u0006\u0010J\u001a\u0002002\u0006\u00101\u001a\u00020\r2\u0006\u0010M\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/worldturner/medeia/parser/jackson/JacksonTokenDataJsonGenerator;", "Lcom/fasterxml/jackson/core/JsonGenerator;", "delegate", "consumer", "Lcom/worldturner/medeia/parser/JsonTokenDataAndLocationConsumer;", "inputSourceName", "", "(Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/worldturner/medeia/parser/JsonTokenDataAndLocationConsumer;Ljava/lang/String;)V", "dynamicTokenLocation", "Lcom/worldturner/medeia/parser/jackson/JacksonTokenDataJsonGenerator$DynamicJsonTokenLocation;", "jsonPointerBuilder", "Lcom/worldturner/medeia/pointer/JsonPointerBuilder;", "<set-?>", "", "level", "getLevel", "()I", "propertyNamesStack", "Ljava/util/ArrayDeque;", "", "close", "", "disable", "f", "Lcom/fasterxml/jackson/core/JsonGenerator$Feature;", "enable", "flush", "getCodec", "Lcom/fasterxml/jackson/core/ObjectCodec;", "getFeatureMask", "getOutputContext", "Lcom/fasterxml/jackson/core/JsonStreamContext;", "isClosed", "", "isEnabled", "setCodec", "oc", "setFeatureMask", "values", "useDefaultPrettyPrinter", "version", "Lcom/fasterxml/jackson/core/Version;", "writeBinary", "bv", "Lcom/fasterxml/jackson/core/Base64Variant;", "data", "Ljava/io/InputStream;", "dataLength", "", "offset", "len", "writeBoolean", "state", "writeEndArray", "writeEndObject", "writeFieldName", "name", "Lcom/fasterxml/jackson/core/SerializableString;", "writeNull", "writeNumber", "v", "Ljava/math/BigDecimal;", "Ljava/math/BigInteger;", "", "", "", "encodedValue", "writeObject", "", "pojo", "", "writeRaw", "c", "", "text", "", "writeRawUTF8String", "length", "writeRawValue", "writeStartArray", "writeStartObject", "writeString", "writeTree", "rootNode", "Lcom/fasterxml/jackson/core/TreeNode;", "writeUTF8String", "DynamicJsonTokenLocation", "medeia-validator-jackson"})
public final class JacksonTokenDataJsonGenerator
extends JsonGenerator {
    private int level;
    private final JsonPointerBuilder jsonPointerBuilder;
    private final DynamicJsonTokenLocation dynamicTokenLocation;
    private final ArrayDeque<Set<String>> propertyNamesStack;
    private final JsonGenerator delegate;
    private final JsonTokenDataAndLocationConsumer consumer;
    private final String inputSourceName;

    public final int getLevel() {
        return this.level;
    }

    @NotNull
    public JsonStreamContext getOutputContext() {
        JsonStreamContext jsonStreamContext = this.delegate.getOutputContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonStreamContext, (String)"delegate.outputContext");
        return jsonStreamContext;
    }

    @NotNull
    public JsonGenerator setFeatureMask(int values) {
        this.delegate.setFeatureMask(values);
        return this;
    }

    @NotNull
    public JsonGenerator setCodec(@Nullable ObjectCodec oc) {
        this.delegate.setCodec(oc);
        return this;
    }

    public boolean isEnabled(@NotNull JsonGenerator.Feature f) {
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        return this.delegate.isEnabled(f);
    }

    @NotNull
    public JsonGenerator disable(@NotNull JsonGenerator.Feature f) {
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        this.delegate.disable(f);
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void writeStartArray() {
        this.consumer.consume(JsonTokenDataKt.getTOKEN_START_ARRAY(), (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeStartArray();
        int n = this.level;
        this.level = n + 1;
    }

    public void writeEndArray() {
        int n = this.level;
        this.level = n + -1;
        this.consumer.consume(JsonTokenDataKt.getTOKEN_END_ARRAY(), (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeEndArray();
    }

    public void writeStartObject() {
        this.consumer.consume(JsonTokenDataKt.getTOKEN_START_OBJECT(), (JsonTokenLocation)this.dynamicTokenLocation);
        this.propertyNamesStack.addFirst(new HashSet());
        this.delegate.writeStartObject();
        int n = this.level;
        this.level = n + 1;
    }

    public void writeEndObject() {
        int n = this.level;
        this.level = n + -1;
        this.consumer.consume(JsonTokenDataKt.getTOKEN_END_OBJECT(), (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeEndObject();
        this.propertyNamesStack.removeFirst();
    }

    public void writeNull() {
        this.consumer.consume(JsonTokenDataKt.getTOKEN_NULL(), (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeNull();
    }

    public void writeNumber(int v) {
        this.consumer.consume(JsonTokenData.Companion.createNumber((long)v), (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeNumber(v);
    }

    public void writeNumber(long v) {
        this.consumer.consume(JsonTokenData.Companion.createNumber(v), (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeNumber(v);
    }

    public void writeNumber(@Nullable BigInteger v) {
        JsonTokenData tokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, v, null, 22, null);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeNumber(v);
    }

    public void writeNumber(double v) {
        JsonTokenData tokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, BigDecimal.valueOf(v), 14, null);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeNumber(v);
    }

    public void writeNumber(float v) {
        JsonTokenData tokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, BigDecimal.valueOf(v), 14, null);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeNumber(v);
    }

    public void writeNumber(@NotNull BigDecimal v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        JsonTokenData tokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, v, 14, null);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeNumber(v);
    }

    public void writeNumber(@NotNull String encodedValue) {
        Intrinsics.checkParameterIsNotNull((Object)encodedValue, (String)"encodedValue");
        JsonTokenData tokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, new BigDecimal(encodedValue), 14, null);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeNumber(encodedValue);
    }

    public void writeString(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        JsonTokenData tokenData = JsonTokenData.Companion.createText(text);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeString(text);
    }

    public void writeString(@NotNull char[] text, int offset, int len) {
        JsonTokenData jsonTokenData;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (len == 0) {
            jsonTokenData = JsonTokenDataKt.getTOKEN_EMPTY_STRING();
        } else {
            JsonTokenData.Companion companion = JsonTokenData.Companion;
            String string = new String(text, offset, len);
            jsonTokenData = companion.createText(string);
        }
        JsonTokenData tokenData = jsonTokenData;
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeString(text, offset, len);
    }

    public void writeString(@NotNull SerializableString text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String string = text.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text.value");
        JsonTokenData tokenData = JsonTokenData.Companion.createText(string);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeString(text);
    }

    @NotNull
    public Void writeUTF8String(@NotNull byte[] text, int offset, int length) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        throw (Throwable)new UnsupportedOperationException();
    }

    public void writeBoolean(boolean state) {
        JsonTokenData tokenData = state ? JsonTokenDataKt.getTOKEN_TRUE() : JsonTokenDataKt.getTOKEN_FALSE();
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeBoolean(state);
    }

    public void writeFieldName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        JsonTokenData tokenData = new JsonTokenData(JsonTokenType.FIELD_NAME, name, 0L, null, null, 28, null);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        Collection collection = this.propertyNamesStack.peek();
        collection.add(name);
        this.delegate.writeFieldName(name);
    }

    public void writeFieldName(@NotNull SerializableString name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String text = name.getValue();
        JsonTokenData tokenData = new JsonTokenData(JsonTokenType.FIELD_NAME, text, 0L, null, null, 28, null);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        Collection collection = this.propertyNamesStack.peek();
        collection.add(text);
        this.delegate.writeFieldName(name);
    }

    public void writeBinary(@NotNull Base64Variant bv, @NotNull byte[] data, int offset, int len) {
        Intrinsics.checkParameterIsNotNull((Object)bv, (String)"bv");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        byte[] byArray = data;
        int n = offset + len;
        Base64Variant base64Variant = bv;
        JsonTokenData.Companion companion = JsonTokenData.Companion;
        byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)offset, (int)n);
        String string = base64Variant.encode(byArray2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bv.encode(data.copyOfRange(offset, offset + len))");
        JsonTokenData tokenData = companion.createText(string);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeBinary(bv, data, offset, len);
    }

    public int writeBinary(@NotNull Base64Variant bv, @NotNull InputStream data, int dataLength) {
        Intrinsics.checkParameterIsNotNull((Object)bv, (String)"bv");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        byte[] bytes = JacksonTokenDataJsonGeneratorKt.readBytesLength(data, dataLength);
        String string = bv.encode(bytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bv.encode(bytes)");
        JsonTokenData tokenData = JsonTokenData.Companion.createText(string);
        this.consumer.consume(tokenData, (JsonTokenLocation)this.dynamicTokenLocation);
        this.delegate.writeBinary(bv, bytes, 0, bytes.length);
        return dataLength;
    }

    @NotNull
    public Void writeRawUTF8String(@Nullable byte[] text, int offset, int length) {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void writeRawValue(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void writeRawValue(@NotNull String text, int offset, int len) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void writeRawValue(@NotNull char[] text, int offset, int len) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void writeRaw(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void writeRaw(@NotNull String text, int offset, int len) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void writeRaw(@NotNull char[] text, int offset, int len) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void writeRaw(char c) {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public JsonGenerator useDefaultPrettyPrinter() {
        this.delegate.useDefaultPrettyPrinter();
        return this;
    }

    public void flush() {
        this.delegate.flush();
    }

    public int getFeatureMask() {
        return this.delegate.getFeatureMask();
    }

    @NotNull
    public JsonGenerator enable(@Nullable JsonGenerator.Feature f) {
        this.delegate.enable(f);
        return this;
    }

    @NotNull
    public ObjectCodec getCodec() {
        ObjectCodec objectCodec = this.delegate.getCodec();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectCodec, (String)"delegate.codec");
        return objectCodec;
    }

    @NotNull
    public Void writeObject(@Nullable Object pojo) {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Void writeTree(@NotNull TreeNode rootNode) {
        Intrinsics.checkParameterIsNotNull((Object)rootNode, (String)"rootNode");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Version version() {
        Version version = this.delegate.version();
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"delegate.version()");
        return version;
    }

    public JacksonTokenDataJsonGenerator(@NotNull JsonGenerator delegate, @NotNull JsonTokenDataAndLocationConsumer consumer, @Nullable String inputSourceName) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        this.delegate = delegate;
        this.consumer = consumer;
        this.inputSourceName = inputSourceName;
        this.jsonPointerBuilder = new JsonPointerBuilder();
        this.dynamicTokenLocation = new DynamicJsonTokenLocation();
        this.propertyNamesStack = new ArrayDeque();
    }

    public static final /* synthetic */ int access$getLevel$p(JacksonTokenDataJsonGenerator $this) {
        return $this.level;
    }

    public static final /* synthetic */ void access$setLevel$p(JacksonTokenDataJsonGenerator $this, int n) {
        $this.level = n;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/worldturner/medeia/parser/jackson/JacksonTokenDataJsonGenerator$DynamicJsonTokenLocation;", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "(Lcom/worldturner/medeia/parser/jackson/JacksonTokenDataJsonGenerator;)V", "inputSourceName", "", "getInputSourceName", "()Ljava/lang/String;", "level", "", "getLevel", "()I", "pointer", "Lcom/worldturner/medeia/pointer/JsonPointer;", "getPointer", "()Lcom/worldturner/medeia/pointer/JsonPointer;", "propertyNames", "", "getPropertyNames", "()Ljava/util/Set;", "toString", "medeia-validator-jackson"})
    public final class DynamicJsonTokenLocation
    implements JsonTokenLocation {
        public int getLevel() {
            return JacksonTokenDataJsonGenerator.this.getLevel();
        }

        @NotNull
        public JsonPointer getPointer() {
            return JacksonTokenDataJsonGenerator.this.jsonPointerBuilder.toJsonPointer();
        }

        @NotNull
        public Set<String> getPropertyNames() {
            Set set = (Set)JacksonTokenDataJsonGenerator.this.propertyNamesStack.peek();
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @Nullable
        public String getInputSourceName() {
            return JacksonTokenDataJsonGenerator.this.inputSourceName;
        }

        @NotNull
        public String toString() {
            String string;
            block3: {
                block2: {
                    String string2;
                    string = this.getInputSourceName();
                    if (string == null) break block2;
                    String it = string2 = string;
                    boolean bl = false;
                    string = "at " + this.getPointer() + " in " + this.getInputSourceName();
                    if (string != null) break block3;
                }
                string = "at " + this.getPointer();
            }
            return string;
        }

        public int getColumn() {
            return JsonTokenLocation.DefaultImpls.getColumn((JsonTokenLocation)this);
        }

        public int getLine() {
            return JsonTokenLocation.DefaultImpls.getLine((JsonTokenLocation)this);
        }
    }
}

