/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns;

import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.internal.Utilities;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class EnhancedApnsNotification
implements ApnsNotification {
    private static final byte COMMAND = 1;
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final int identifier;
    private final int expiry;
    private final byte[] deviceToken;
    private final byte[] payload;
    public static final int MAXIMUM_EXPIRY = Integer.MAX_VALUE;
    private byte[] marshall = null;

    public static int INCREMENT_ID() {
        return nextId.incrementAndGet();
    }

    public EnhancedApnsNotification(int identifier, int expiryTime, String dtoken, String payload) {
        this.identifier = identifier;
        this.expiry = expiryTime;
        this.deviceToken = Utilities.decodeHex(dtoken);
        this.payload = Utilities.toUTF8Bytes(payload);
    }

    public EnhancedApnsNotification(int identifier, int expiryTime, byte[] dtoken, byte[] payload) {
        this.identifier = identifier;
        this.expiry = expiryTime;
        this.deviceToken = Utilities.copyOf(dtoken);
        this.payload = Utilities.copyOf(payload);
    }

    @Override
    public byte[] getDeviceToken() {
        return Utilities.copyOf(this.deviceToken);
    }

    @Override
    public byte[] getPayload() {
        return Utilities.copyOf(this.payload);
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getExpiry() {
        return this.expiry;
    }

    @Override
    public byte[] marshall() {
        if (this.marshall == null) {
            this.marshall = Utilities.marshallEnhanced((byte)1, this.identifier, this.expiry, this.deviceToken, this.payload);
        }
        return (byte[])this.marshall.clone();
    }

    public int length() {
        int length = 11 + this.deviceToken.length + 2 + this.payload.length;
        int marshalledLength = this.marshall().length;
        assert (marshalledLength == length);
        return length;
    }

    public int hashCode() {
        return 21 + 31 * this.identifier + 31 * this.expiry + 31 * Arrays.hashCode(this.deviceToken) + 31 * Arrays.hashCode(this.payload);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EnhancedApnsNotification)) {
            return false;
        }
        EnhancedApnsNotification o = (EnhancedApnsNotification)obj;
        return this.identifier == o.identifier && this.expiry == o.expiry && Arrays.equals(this.deviceToken, o.deviceToken) && Arrays.equals(this.payload, o.payload);
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    public String toString() {
        String payloadString;
        try {
            payloadString = new String(this.payload, "UTF-8");
        }
        catch (Exception ex) {
            payloadString = "???";
        }
        return "Message(Id=" + this.identifier + "; Token=" + Utilities.encodeHex(this.deviceToken) + "; Payload=" + payloadString + ")";
    }
}

