/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.internal.Utilities;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectMethod;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.ProxyClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TlsTunnelBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TlsTunnelBuilder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket build(SSLSocketFactory factory, Proxy proxy, String proxyUsername, String proxyPassword, String host, int port) throws IOException {
        Socket socket;
        block4: {
            boolean success = false;
            Socket proxySocket = null;
            try {
                logger.debug("Attempting to use proxy : " + proxy.toString());
                InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
                proxySocket = this.makeTunnel(host, port, proxyUsername, proxyPassword, proxyAddress);
                if (proxySocket == null) {
                    throw new ProtocolException("Unable to create tunnel through proxy server.");
                }
                Socket socket2 = factory.createSocket(proxySocket, host, port, true);
                success = true;
                socket = socket2;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Utilities.close(proxySocket);
                }
                throw throwable;
            }
            Utilities.close(proxySocket);
        }
        return socket;
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="use <CR><LF> as according to RFC, not platform-linefeed")
    Socket makeTunnel(String host, int port, String proxyUsername, String proxyPassword, InetSocketAddress proxyAddress) throws IOException {
        Socket socket;
        block5: {
            if (host == null || port < 0 || host.isEmpty() || proxyAddress == null) {
                throw new ProtocolException("Incorrect parameters to build tunnel.");
            }
            logger.debug("Creating socket for Proxy : " + proxyAddress.getAddress() + ":" + proxyAddress.getPort());
            try {
                ConnectMethod method;
                ProxyClient client = new ProxyClient();
                client.getParams().setParameter("http.useragent", (Object)"java-apns");
                client.getHostConfiguration().setHost(host, port);
                String proxyHost = proxyAddress.getAddress().toString().substring(0, proxyAddress.getAddress().toString().indexOf("/"));
                client.getHostConfiguration().setProxy(proxyHost, proxyAddress.getPort());
                ProxyClient.ConnectResponse response = client.connect();
                socket = response.getSocket();
                if (socket != null || !(method = response.getConnectMethod()).getStatusLine().toString().matches("HTTP/1\\.\\d 407 Proxy Authentication Required")) break block5;
                if (proxyUsername != null && proxyPassword != null) {
                    socket = this.AuthenticateProxy(method, client, proxyHost, proxyAddress.getPort(), proxyUsername, proxyPassword);
                    break block5;
                }
                throw new ProtocolException("Socket not created: " + method.getStatusLine());
            }
            catch (Exception e) {
                throw new ProtocolException("Error occurred while creating proxy socket : " + e.toString());
            }
        }
        if (socket != null) {
            logger.debug("Socket for proxy created successfully : " + socket.getRemoteSocketAddress().toString());
        }
        return socket;
    }

    private Socket AuthenticateProxy(ConnectMethod method, ProxyClient client, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword) throws IOException {
        if (method.getProxyAuthState().getAuthScheme().getSchemeName().equalsIgnoreCase("ntlm")) {
            client.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, "", ""));
        } else {
            client.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
        }
        ProxyClient.ConnectResponse response = client.connect();
        Socket socket = response.getSocket();
        if (socket == null) {
            method = response.getConnectMethod();
            throw new ProtocolException("Proxy Authentication failed. Socket not created: " + method.getStatusLine());
        }
        return socket;
    }
}

