/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.apns;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.exceptions.ApnsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.apns.ApnsEndpoint;
import org.apache.camel.component.apns.model.MessageType;
import org.apache.camel.component.apns.util.StringUtils;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class ApnsProducer
extends DefaultProducer {
    private List<String> tokenList;

    public ApnsProducer(ApnsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.initiate(endpoint);
    }

    public ApnsEndpoint getEndpoint() {
        return (ApnsEndpoint)super.getEndpoint();
    }

    private void initiate(ApnsEndpoint apnsEndpoint) {
        this.configureTokens(apnsEndpoint);
    }

    private void configureTokens(ApnsEndpoint apnsEndpoint) {
        if (ObjectHelper.isNotEmpty((Object)apnsEndpoint.getTokens())) {
            this.tokenList = this.extractTokensFromString(apnsEndpoint.getTokens());
        }
    }

    public boolean isTokensConfiguredUsingUri() {
        return this.tokenList != null;
    }

    public void process(Exchange exchange) throws Exception {
        this.notify(exchange);
    }

    private void notify(Exchange exchange) throws ApnsException {
        MessageType messageType = this.getHeaderMessageType(exchange, MessageType.STRING);
        if (messageType == MessageType.APNS_NOTIFICATION) {
            ApnsNotification apnsNotification = (ApnsNotification)exchange.getIn().getBody(ApnsNotification.class);
            this.getEndpoint().getApnsService().push(apnsNotification);
        } else {
            this.constructNotificationAndNotify(exchange, messageType);
        }
    }

    private void constructNotificationAndNotify(Exchange exchange, MessageType messageType) {
        String payload;
        String message;
        List<String> tokens;
        if (this.isTokensConfiguredUsingUri()) {
            if (this.hasTokensHeader(exchange)) {
                throw new IllegalArgumentException("Tokens already configured on endpoint CamelApnsTokens");
            }
            tokens = new ArrayList<String>(this.tokenList);
        } else {
            String tokensHeader = this.getHeaderTokens(exchange);
            tokens = this.extractTokensFromString(tokensHeader);
        }
        if (messageType == MessageType.STRING) {
            message = (String)exchange.getIn().getBody(String.class);
            payload = APNS.newPayload().alertBody(message).build();
        } else {
            payload = message = (String)exchange.getIn().getBody(String.class);
        }
        Date expiry = (Date)exchange.getIn().getHeader("CamelApnsExpiry", Date.class);
        if (expiry != null) {
            this.getEndpoint().getApnsService().push(tokens, payload, expiry);
        } else {
            this.getEndpoint().getApnsService().push(tokens, payload);
        }
    }

    public String getHeaderTokens(Exchange exchange) {
        return (String)exchange.getIn().getHeader("CamelApnsTokens", String.class);
    }

    public MessageType getHeaderMessageType(Exchange exchange, MessageType defaultMessageType) {
        String messageTypeStr = (String)exchange.getIn().getHeader("CamelApnsMessageType");
        if (messageTypeStr == null) {
            return defaultMessageType;
        }
        MessageType messageType = MessageType.valueOf(messageTypeStr);
        return messageType;
    }

    private boolean hasTokensHeader(Exchange exchange) {
        return this.getHeaderTokens(exchange) != null;
    }

    private List<String> extractTokensFromString(String tokensStr) {
        if ((tokensStr = StringUtils.trim(tokensStr)).isEmpty()) {
            throw new IllegalArgumentException("No token specified");
        }
        String[] tokenArray = tokensStr.split(";");
        int tokenArrayLength = tokenArray.length;
        for (int i = 0; i < tokenArrayLength; ++i) {
            String token = tokenArray[i];
            tokenArray[i] = token.trim();
            int tokenLength = token.length();
            if (tokenLength == 64) continue;
            throw new IllegalArgumentException("Token has wrong size['" + tokenLength + "']: " + token);
        }
        List<String> tokens = Arrays.asList(tokenArray);
        return tokens;
    }
}

