/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos;

import com.emc.atmos.AbstractConfig;
import com.emc.util.BasicResponse;
import com.emc.util.HttpUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public abstract class AbstractJerseyClient<C extends AbstractConfig> {
    protected C config;
    protected Client client;

    public AbstractJerseyClient(C config) {
        this.config = config;
        this.client = this.createClient(config);
    }

    protected abstract Client createClient(C var1);

    protected <T extends BasicResponse> T fillResponse(T response, ClientResponse clientResponse) {
        Response.StatusType statusType = clientResponse.getStatusInfo();
        MediaType type = clientResponse.getType();
        URI location = clientResponse.getLocation();
        response.setHttpStatus(clientResponse.getStatus());
        response.setHttpMessage(statusType == null ? null : statusType.getReasonPhrase());
        response.setHeaders((Map<String, List<String>>)clientResponse.getHeaders());
        response.setContentType(type == null ? null : type.toString());
        response.setContentLength(clientResponse.getLength());
        response.setLocation(location == null ? null : location.toString());
        if (clientResponse.getHeaders() != null) {
            response.setDate(HttpUtil.safeHeaderParse((String)clientResponse.getHeaders().getFirst((Object)"Date")));
            response.setLastModified(HttpUtil.safeHeaderParse((String)clientResponse.getHeaders().getFirst((Object)"Last-Modified")));
            response.setETag((String)clientResponse.getHeaders().getFirst((Object)"ETag"));
        }
        return response;
    }

    protected <R extends BasicResponse> R executeAndClose(WebResource.Builder builder, Class<R> responseType) {
        ClientResponse response = builder.get(ClientResponse.class);
        BasicResponse ret = (BasicResponse)response.getEntity(responseType);
        response.close();
        return (R)this.fillResponse(ret, response);
    }

    protected WebResource.Builder buildRequest(String pathWithinContext, String query) {
        URI uri = ((AbstractConfig)this.config).resolveHostAndPath(pathWithinContext, query);
        return this.client.resource(uri).getRequestBuilder();
    }
}

