/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import java.io.IOException;
import java.io.InputStream;

public class MeasuredInputStream
extends InputStream {
    private InputStream source;
    private long size;
    private long read = 0L;

    public MeasuredInputStream(InputStream source, long size) {
        this.source = source;
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public long getRead() {
        return this.read;
    }

    @Override
    public int read() throws IOException {
        int value = this.source.read();
        if (value != -1) {
            ++this.read;
        }
        return value;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        int count = this.source.read(bytes);
        if (count != -1) {
            this.read += (long)count;
        }
        return count;
    }

    @Override
    public int read(byte[] bytes, int i, int i1) throws IOException {
        int count = this.source.read(bytes, i, i1);
        if (count != -1) {
            this.read += (long)count;
        }
        return count;
    }

    @Override
    public long skip(long l) throws IOException {
        long count = this.source.skip(l);
        if (count != -1L) {
            this.read += count;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.source.available();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public void mark(int i) {
        this.source.mark(i);
    }

    @Override
    public void reset() throws IOException {
        this.source.reset();
    }

    @Override
    public boolean markSupported() {
        return this.source.markSupported();
    }
}

