/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.compression;

import com.emc.vipr.transform.TransformConstants;
import com.emc.vipr.transform.compression.CompressionOutputTransform;
import com.emc.vipr.transform.compression.LZMACompressionFilter;
import com.emc.vipr.transform.compression.LZMAOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class LZMAOutputTransform
extends CompressionOutputTransform {
    public LZMAOutputTransform(OutputStream streamToEncodeTo, Map<String, String> metadataToEncode, int level) throws IOException {
        super(streamToEncodeTo, metadataToEncode, "COMP:" + (Object)((Object)TransformConstants.CompressionMode.LZMA) + "/" + level);
        if (level > 9 || level < 0) {
            throw new IllegalArgumentException("Invalid compression level " + level);
        }
        this.pushStream = new LZMAOutputStream(streamToEncodeTo, level);
    }

    public LZMAOutputTransform(InputStream streamToEncode, Map<String, String> metadataToEncode, int level) throws IOException {
        super(streamToEncode, metadataToEncode, "COMP:" + (Object)((Object)TransformConstants.CompressionMode.LZMA) + "/" + level);
        if (level > 9 || level < 0) {
            throw new IllegalArgumentException("Invalid compression level " + level);
        }
        this.pullStream = new LZMACompressionFilter(streamToEncode, level);
    }

    @Override
    public Map<String, String> getEncodedMetadata() {
        HashMap<String, String> outputMetadata = new HashMap<String, String>();
        switch (this.getStreamMode()) {
            case PULL: {
                outputMetadata.putAll(((LZMACompressionFilter)this.pullStream).getStreamMetadata());
                break;
            }
            case PUSH: {
                outputMetadata.putAll(((LZMAOutputStream)this.pushStream).getStreamMetadata());
            }
        }
        outputMetadata.putAll(this.metadataToEncode);
        return outputMetadata;
    }
}

