/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.encryption;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESTest {
    public static void main(String[] args) {
        try {
            Mode m = Mode.valueOf(args[0]);
            if (m == Mode.ENCRYPT) {
                int bits = Integer.valueOf(args[1]);
                String infile = args[2];
                String outfile = args[3];
                KeyGenerator kg = KeyGenerator.getInstance("AES");
                kg.init(bits);
                SecretKey sk = kg.generateKey();
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(1, sk);
                System.out.println("Key: " + new String(Base64.encodeBase64((byte[])sk.getEncoded()), "US-ASCII"));
                System.out.println("IV: " + new String(Base64.encodeBase64((byte[])cipher.getIV()), "US-ASCII"));
                CipherOutputStream out = new CipherOutputStream(new FileOutputStream(new File(outfile)), cipher);
                FileInputStream in = new FileInputStream(new File(infile));
                AESTest.doStream(in, out);
                out.close();
                ((InputStream)in).close();
            } else if (m == Mode.DECRYPT) {
                String key = args[1];
                String iv = args[2];
                String infile = args[3];
                String outfile = args[4];
                SecretKeySpec sk = new SecretKeySpec(Base64.decodeBase64((byte[])key.getBytes("US-ASCII")), "AES");
                IvParameterSpec ivspec = new IvParameterSpec(Base64.decodeBase64((byte[])iv.getBytes("US-ASCII")));
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(2, (Key)sk, ivspec);
                CipherInputStream in = new CipherInputStream(new FileInputStream(new File(infile)), cipher);
                FileOutputStream out = new FileOutputStream(new File(outfile));
                AESTest.doStream(in, out);
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void doStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[131072];
        int c = 0;
        while ((c = in.read(buffer)) != -1) {
            out.write(buffer, 0, c);
        }
    }

    private static enum Mode {
        ENCRYPT,
        DECRYPT;

    }
}

