/*
 * Decompiled with CFR 0.152.
 */
package com.emc.acdp.api.jersey;

import com.emc.acdp.api.AcdpMgmtApi;
import com.emc.acdp.api.AcdpMgmtConfig;
import com.emc.acdp.api.jersey.JerseyUtil;
import com.emc.cdp.services.rest.model.Identity;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

public class AcdpMgmtApiClient
implements AcdpMgmtApi {
    private AcdpMgmtConfig config;
    private Client client;

    public AcdpMgmtApiClient(AcdpMgmtConfig config) {
        this.config = config;
        this.client = JerseyUtil.createClient(config);
    }

    public AcdpMgmtApiClient(AcdpMgmtConfig config, Client client) {
        this.config = config;
        JerseyUtil.configureClient(client, config);
        this.client = client;
    }

    @Override
    public void createIdentity(Identity identity) {
        WebResource resource = this.client.resource(this.getMgmtUri() + "/identities");
        resource.type("text/xml").post(identity);
    }

    @Override
    public void createAccount(String serviceId) {
        WebResource.Builder builder = this.client.resource(this.getMgmtUri() + "/accounts").getRequestBuilder();
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle((Object)"serviceId", (Object)serviceId);
        ((WebResource.Builder)builder.type("application/x-www-form-urlencoded")).post(params);
    }

    private String getMgmtUri() {
        return this.config.getBaseUri() + "/cdp-rest/v1";
    }
}

