/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.bean;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="Service")
public class ServiceInformation {
    private Version version;
    private Set<Feature> features = new HashSet<Feature>();

    @XmlTransient
    public String getAtmosVersion() {
        if (this.version == null) {
            return null;
        }
        return this.version.getAtmos();
    }

    @XmlElement(name="Version")
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void addFeature(Feature feature) {
        this.features.add(feature);
    }

    public void addFeatureFromHeaderName(String headerName) {
        this.features.add(Feature.fromHeaderName(headerName));
    }

    public boolean hasFeature(Feature feature) {
        return this.features.contains((Object)feature);
    }

    @XmlTransient
    public Set<Feature> getFeatures() {
        return Collections.unmodifiableSet(this.features);
    }

    @XmlTransient
    public static enum Feature {
        Object("object"),
        Namespace("namespace"),
        Utf8("utf-8"),
        BrowserCompat("browser-compat"),
        KeyValue("key-value"),
        Hardlink("hardlink"),
        Query("query"),
        Versioning("versioning");

        private String headerName;

        public static Feature fromHeaderName(String headerName) {
            for (Feature feature : Feature.values()) {
                if (!feature.getHeaderName().equals(headerName)) continue;
                return feature;
            }
            return null;
        }

        private Feature(String headerName) {
            this.headerName = headerName;
        }

        public String getHeaderName() {
            return this.headerName;
        }
    }

    private static class Version {
        private String atmos;

        private Version() {
        }

        @XmlElement(name="Atmos")
        public String getAtmos() {
            return this.atmos;
        }

        public void setAtmos(String atmos) {
            this.atmos = atmos;
        }
    }
}

