/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class OutputTransform {
    protected OutputStream pushStream;
    protected InputStream pullStream;
    protected Map<String, String> metadataToEncode;
    private String transformConfig;
    private StreamMode mode;

    public OutputTransform(OutputStream streamToEncode, Map<String, String> metadataToEncode, String transformConfig) {
        this.pushStream = streamToEncode;
        this.metadataToEncode = metadataToEncode;
        this.transformConfig = transformConfig;
        this.mode = StreamMode.PUSH;
    }

    public OutputTransform(InputStream streamtoEncode, Map<String, String> metadataToEncode, String transformConfig) {
        this.pullStream = streamtoEncode;
        this.metadataToEncode = metadataToEncode;
        this.transformConfig = transformConfig;
        this.mode = StreamMode.PULL;
    }

    public StreamMode getStreamMode() {
        return this.mode;
    }

    public OutputStream getEncodedOutputStream() {
        if (this.mode != StreamMode.PUSH) {
            throw new IllegalStateException("Cannot get output stream in pull mode");
        }
        return this.pushStream;
    }

    public InputStream getEncodedInputStream() {
        if (this.mode != StreamMode.PULL) {
            throw new IllegalStateException("Cannot get output stream in pull mode");
        }
        return this.pullStream;
    }

    public abstract Map<String, String> getEncodedMetadata();

    public String getTransformConfig() {
        return this.transformConfig;
    }

    public static enum StreamMode {
        PUSH,
        PULL;

    }
}

