/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.compression;

import SevenZip.Compression.LZMA.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class LZMAInputStream
extends InputStream
implements Runnable {
    private static ThreadGroup tg = new ThreadGroup("LZMA Decompress");
    private InputStream compressedStream;
    private Thread decompressionThread;
    private PipedOutputStream uncompressedPipeOut;
    private PipedInputStream uncompressedPipeIn;
    boolean closed;
    private Exception decompressionException;
    private Decoder lzma;
    private Boolean decompressionComplete;

    public LZMAInputStream(InputStream compressedStream) throws IOException {
        this(compressedStream, 4096);
    }

    public LZMAInputStream(InputStream compressedStream, int bufferSize) throws IOException {
        this.compressedStream = compressedStream;
        this.lzma = new Decoder();
        byte[] properties = new byte[5];
        int c = compressedStream.read(properties);
        if (c != properties.length) {
            throw new IOException("Unable to compression settings from stream");
        }
        if (!this.lzma.SetDecoderProperties(properties)) {
            throw new IOException("LZMA decoder rejected compression settings from stream");
        }
        this.uncompressedPipeIn = new PipedInputStream(bufferSize);
        this.uncompressedPipeOut = new PipedOutputStream(this.uncompressedPipeIn);
        this.decompressionThread = new Thread(tg, this);
        this.closed = false;
        this.setDecompressionComplete(Boolean.FALSE);
        this.decompressionThread.start();
    }

    @Override
    public int read() throws IOException {
        this.checkStream();
        try {
            return this.uncompressedPipeIn.read();
        }
        catch (IOException e) {
            if (this.getDecompressionComplete().booleanValue()) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        return this.uncompressedPipeIn.available();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.compressedStream.close();
        try {
            this.decompressionThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.uncompressedPipeIn.close();
        this.uncompressedPipeOut.close();
        this.lzma = null;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        try {
            return this.uncompressedPipeIn.read(b, off, len);
        }
        catch (IOException e) {
            if (this.getDecompressionComplete().booleanValue()) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkStream();
        try {
            return this.uncompressedPipeIn.read(b);
        }
        catch (IOException e) {
            if (this.getDecompressionComplete().booleanValue()) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkStream();
        try {
            return this.uncompressedPipeIn.skip(n);
        }
        catch (IOException e) {
            if (this.getDecompressionComplete().booleanValue()) {
                return -1L;
            }
            throw e;
        }
    }

    private void checkStream() throws IOException {
        if (this.decompressionException != null) {
            throw new IOException("Error decompressing data", this.decompressionException);
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void run() {
        try {
            this.lzma.Code(this.compressedStream, this.uncompressedPipeOut, -1L);
            this.uncompressedPipeOut.close();
        }
        catch (Exception e) {
            this.decompressionException = e;
        }
        this.setDecompressionComplete(Boolean.TRUE);
    }

    private synchronized Boolean getDecompressionComplete() {
        return this.decompressionComplete;
    }

    private synchronized void setDecompressionComplete(Boolean decompressionComplete) {
        this.decompressionComplete = decompressionComplete;
    }
}

