/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import com.emc.atmos.AtmosException;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class ErrorFilter
extends ClientFilter {
    private static final Logger log = Logger.getLogger(ErrorFilter.class);
    public static final String NO_EXCEPTIONS = "ErrorFilter.noExceptions";

    @Override
    public ClientResponse handle(ClientRequest clientRequest) throws ClientHandlerException {
        ClientResponse response = this.getNext().handle(clientRequest);
        if (response.getStatus() > 299 && this.shouldThrowExceptions(clientRequest)) {
            String message;
            Document d;
            SAXBuilder sb = new SAXBuilder();
            try {
                d = sb.build(response.getEntityInputStream());
            }
            catch (Throwable t) {
                throw new AtmosException(response.getStatusInfo().getReasonPhrase(), response.getStatus());
            }
            String code = d.getRootElement().getChildText("Code");
            if (code == null) {
                code = d.getRootElement().getChildText("Code", Namespace.getNamespace((String)"http://www.emc.com/cos/"));
            }
            if ((message = d.getRootElement().getChildText("Message")) == null) {
                message = d.getRootElement().getChildText("Message", Namespace.getNamespace((String)"http://www.emc.com/cos/"));
            }
            if (code == null && message == null) {
                throw new AtmosException(response.getStatusInfo().getReasonPhrase(), response.getStatus());
            }
            log.debug((Object)("Error: " + code + " message: " + message));
            throw new AtmosException(message, response.getStatus(), Integer.parseInt(code));
        }
        return response;
    }

    private boolean shouldThrowExceptions(ClientRequest request) {
        Boolean noExceptions = (Boolean)request.getProperties().get(NO_EXCEPTIONS);
        return noExceptions == null || noExceptions == false;
    }
}

