/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import com.emc.atmos.AtmosException;
import com.emc.atmos.api.AtmosConfig;
import com.emc.atmos.api.jersey.AuthFilter;
import com.emc.atmos.api.jersey.ChecksumFilter;
import com.emc.atmos.api.jersey.ErrorFilter;
import com.emc.atmos.api.jersey.ProxyAuthFilter;
import com.emc.atmos.api.jersey.ProxyURLConnectionFactory;
import com.emc.atmos.api.jersey.RetryFilter;
import com.emc.atmos.api.jersey.provider.BufferSegmentWriter;
import com.emc.atmos.api.jersey.provider.MeasuredInputStreamWriter;
import com.emc.atmos.api.jersey.provider.MeasuredJaxbWriter;
import com.emc.atmos.api.jersey.provider.MeasuredStringWriter;
import com.emc.atmos.api.jersey.provider.MultipartReader;
import com.emc.util.SslUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.core.impl.provider.entity.ByteArrayProvider;
import com.sun.jersey.core.impl.provider.entity.FileProvider;
import com.sun.jersey.core.impl.provider.entity.StringProvider;
import com.sun.jersey.core.impl.provider.entity.XMLRootElementProvider;
import java.util.List;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

public class JerseyUtil {
    public static Client createClient(AtmosConfig config, List<Class<MessageBodyReader<?>>> readers, List<Class<MessageBodyWriter<?>>> writers) {
        try {
            Client client;
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            if (config.isDisableSslValidation()) {
                clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(SslUtil.gullibleVerifier, SslUtil.createGullibleSslContext()));
            }
            JerseyUtil.addHandlers(clientConfig, readers, writers);
            if (config.getProxyUri() != null) {
                ProxyURLConnectionFactory factory = new ProxyURLConnectionFactory(config.getProxyUri(), config.getProxyUser(), config.getProxyPassword());
                client = new Client(new URLConnectionClientHandler(factory), clientConfig);
            } else {
                client = Client.create(clientConfig);
            }
            String proxyUser = config.getProxyUser();
            String proxyPassword = config.getProxyPassword();
            if (proxyUser == null) {
                proxyUser = System.getProperty("http.proxyUser");
                proxyPassword = System.getProperty("http.proxyPassword");
            }
            client.addFilter(new ProxyAuthFilter(proxyUser, proxyPassword));
            JerseyUtil.addFilters(client, config);
            return client;
        }
        catch (Exception e) {
            throw new AtmosException("Error configuring REST client", e);
        }
    }

    static void addHandlers(ClientConfig clientConfig, List<Class<MessageBodyReader<?>>> readers, List<Class<MessageBodyWriter<?>>> writers) {
        clientConfig.getClasses().clear();
        clientConfig.getClasses().add(MeasuredStringWriter.class);
        clientConfig.getClasses().add(MeasuredJaxbWriter.App.class);
        clientConfig.getClasses().add(MeasuredJaxbWriter.Text.class);
        clientConfig.getClasses().add(MeasuredJaxbWriter.General.class);
        clientConfig.getClasses().add(MeasuredInputStreamWriter.class);
        clientConfig.getClasses().add(BufferSegmentWriter.class);
        clientConfig.getClasses().add(MultipartReader.class);
        clientConfig.getClasses().add(ByteArrayProvider.class);
        clientConfig.getClasses().add(FileProvider.class);
        clientConfig.getClasses().add(StringProvider.class);
        clientConfig.getClasses().add(XMLRootElementProvider.App.class);
        clientConfig.getClasses().add(XMLRootElementProvider.Text.class);
        clientConfig.getClasses().add(XMLRootElementProvider.General.class);
        if (readers != null) {
            for (Class<MessageBodyReader<?>> clazz : readers) {
                clientConfig.getClasses().add(clazz);
            }
        }
        if (writers != null) {
            for (Class<MessageBodyReader<?>> clazz : writers) {
                clientConfig.getClasses().add(clazz);
            }
        }
    }

    static void addFilters(Client client, AtmosConfig config) {
        client.addFilter(new ChecksumFilter());
        client.addFilter(new ErrorFilter());
        if (config.isEnableRetry()) {
            client.addFilter(new RetryFilter(config));
        }
        client.addFilter(new AuthFilter(config));
    }

    private JerseyUtil() {
    }
}

