/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.DatatypeConverter;

public class ProxyAuthFilter
extends ClientFilter {
    private String proxyUser;
    private String proxyPassword;

    public ProxyAuthFilter(String proxyUser, String proxyPassword) {
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
    }

    @Override
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        this.handleProxyAuth(request);
        return this.getNext().handle(request);
    }

    protected void handleProxyAuth(ClientRequest request) {
        if (this.proxyUser != null && this.proxyUser.length() > 0) {
            String userPass64;
            String userPass = this.proxyUser + ":" + (this.proxyPassword == null ? "null" : this.proxyPassword);
            try {
                userPass64 = DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                userPass64 = DatatypeConverter.printBase64Binary((byte[])userPass.getBytes());
            }
            userPass64 = userPass64.replaceAll("\n", "");
            request.getHeaders().putSingle((Object)"Proxy-Authorization", (Object)("Basic " + userPass64));
        }
    }
}

