/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.encryption;

import com.emc.vipr.transform.util.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

public class EncryptionInputFilter
extends InputStream {
    boolean closed = false;
    byte[] digest = null;
    private DigestInputStream digestStream;
    private CountingInputStream counterStream;
    private CipherInputStream cipherStream;

    public EncryptionInputFilter(InputStream in, Cipher cipher, MessageDigest digest) {
        this.counterStream = new CountingInputStream(in);
        if (digest != null) {
            this.digestStream = new DigestInputStream(this.counterStream, digest);
            this.cipherStream = new CipherInputStream(this.digestStream, cipher);
        } else {
            this.cipherStream = new CipherInputStream(this.counterStream, cipher);
        }
    }

    @Override
    public int read() throws IOException {
        return this.cipherStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.cipherStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.cipherStream.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cipherStream.close();
        if (this.digestStream != null) {
            this.digest = this.digestStream.getMessageDigest().digest();
        }
    }

    @Override
    public int available() throws IOException {
        return this.cipherStream.available();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.cipherStream.skip(n);
    }

    public byte[] getDigest() {
        if (!this.closed) {
            throw new IllegalStateException("Cannot get digest until stream is closed");
        }
        return this.digest;
    }

    public long getByteCount() {
        return this.counterStream.getByteCount();
    }
}

