/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api;

import com.emc.atmos.AtmosException;
import com.emc.atmos.api.ObjectId;
import com.emc.atmos.api.bean.Metadata;
import com.emc.atmos.api.bean.Permission;
import com.emc.util.HttpUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public final class RestUtil {
    public static final String XHEADER_CONTENT_CHECKSUM = "x-emc-content-checksum";
    public static final String XHEADER_DATE = "x-emc-date";
    public static final String XHEADER_EXPIRES = "x-emc-expires";
    public static final String XHEADER_FEATURES = "x-emc-features";
    public static final String XHEADER_FORCE = "x-emc-force";
    public static final String XHEADER_GENERATE_CHECKSUM = "x-emc-generate-checksum";
    public static final String XHEADER_GROUP_ACL = "x-emc-groupacl";
    public static final String XHEADER_INCLUDE_META = "x-emc-include-meta";
    public static final String XHEADER_LIMIT = "x-emc-limit";
    public static final String XHEADER_LISTABLE_META = "x-emc-listable-meta";
    public static final String XHEADER_LISTABLE_TAGS = "x-emc-listable-tags";
    public static final String XHEADER_META = "x-emc-meta";
    public static final String XHEADER_OBJECT_ID = "x-emc-object-id";
    public static final String XHEADER_OBJECTID = "x-emc-objectid";
    public static final String XHEADER_PATH = "x-emc-path";
    public static final String XHEADER_POOL = "x-emc-pool";
    public static final String XHEADER_RETENTION_PERIOD = "x-emc-retention-period";
    public static final String XHEADER_RETENTION_POLICY = "x-emc-retention-policy";
    public static final String XHEADER_SIGNATURE = "x-emc-signature";
    public static final String XHEADER_SUBTENANT_ID = "x-emc-subtenant-id";
    public static final String XHEADER_SUPPORT_UTF8 = "x-emc-support-utf8";
    public static final String XHEADER_SYSTEM_TAGS = "x-emc-system-tags";
    public static final String XHEADER_TAGS = "x-emc-tags";
    public static final String XHEADER_TOKEN = "x-emc-token";
    public static final String XHEADER_UID = "x-emc-uid";
    public static final String XHEADER_USER_ACL = "x-emc-useracl";
    public static final String XHEADER_USER_TAGS = "x-emc-user-tags";
    public static final String XHEADER_UTF8 = "x-emc-utf8";
    public static final String XHEADER_VERSION_OID = "x-emc-version-oid";
    public static final String XHEADER_WSCHECKSUM = "x-emc-wschecksum";
    public static final String XHEADER_OBJECT_VPOOL = "x-emc-vpool";
    private static final String USER_MAUI_PREFIX = "user.maui.";
    public static final String METADATA_KEY_EXPIRATION_ENABLE = "user.maui.expirationEnable";
    public static final String METADATA_KEY_EXPIRATION_END = "user.maui.expirationEnd";
    public static final String METADATA_KEY_RETENTION_ENABLE = "user.maui.retentionEnable";
    public static final String METADATA_KEY_RETENTION_END = "user.maui.retentionEnd";
    public static final String TYPE_MULTIPART = "multipart";
    public static final String TYPE_MULTIPART_BYTE_RANGES = "multipart/byteranges";
    public static final String TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String TYPE_DEFAULT = "application/octet-stream";
    public static final String TYPE_PARAM_BOUNDARY = "boundary";
    public static final String PROP_ENABLE_EXPECT_100_CONTINUE = "com.emc.atmos.api.expect100Continue";
    private static final Logger l4j = Logger.getLogger(RestUtil.class);
    private static final Pattern OBJECTID_PATTERN = Pattern.compile("/\\w+/objects/([0-9a-f-]{44,})");

    public static String sign(String string, byte[] hashKey) {
        try {
            l4j.debug((Object)("Hashing: \n" + string));
            byte[] input = string.getBytes("UTF-8");
            Mac mac = Mac.getInstance("HmacSHA1");
            SecretKeySpec key = new SecretKeySpec(hashKey, "HmacSHA1");
            mac.init(key);
            byte[] hashBytes = mac.doFinal(input);
            String hash = DatatypeConverter.printBase64Binary((byte[])hashBytes);
            l4j.debug((Object)("Hash: " + hash));
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing string:\n" + string + "\n", e);
        }
    }

    public static void signRequest(String method, String path, String query, Map<String, List<Object>> headers, String uid, byte[] hashKey, long serverClockSkew) {
        Date serverTime = new Date(System.currentTimeMillis() - serverClockSkew);
        headers.put("Date", Arrays.asList(HttpUtil.headerFormat(serverTime)));
        headers.put(XHEADER_DATE, Arrays.asList(HttpUtil.headerFormat(serverTime)));
        if (!headers.containsKey(XHEADER_UID)) {
            headers.put(XHEADER_UID, Arrays.asList(uid));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(method).append("\n");
        builder.append(RestUtil.generateHashLine(headers, "Content-Type"));
        builder.append(RestUtil.generateHashLine(headers, "Range"));
        builder.append(RestUtil.generateHashLine(headers, "Date"));
        builder.append(path.toLowerCase());
        if (query != null) {
            builder.append("?").append(query);
        }
        builder.append("\n");
        TreeMap<String, String> emcHeaders = new TreeMap<String, String>();
        for (String key : headers.keySet()) {
            String lowerKey = key.toLowerCase();
            if (lowerKey.indexOf("x-emc") != 0) continue;
            emcHeaders.put(lowerKey, RestUtil.join((Iterable)headers.get(key), ","));
        }
        Iterator i = emcHeaders.keySet().iterator();
        while (i.hasNext()) {
            String key;
            key = (String)i.next();
            builder.append(key).append(':').append(RestUtil.normalizeSpace((String)emcHeaders.get(key)));
            if (!i.hasNext()) continue;
            builder.append("\n");
        }
        String hash = RestUtil.sign(builder.toString(), hashKey);
        headers.put(XHEADER_SIGNATURE, Arrays.asList(hash));
    }

    public static String normalizeSpace(String str) {
        int length;
        while ((length = str.length()) != (str = str.replace("  ", " ")).length()) {
        }
        return str.replace("\n", "").trim();
    }

    public static String join(Iterable<?> list, String delimiter) {
        if (list == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Iterator<?> i = list.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            builder.append(value);
            if (!i.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static void addValue(Map<String, List<Object>> multiValueMap, String key, Object value) {
        List<Object> values = multiValueMap.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            multiValueMap.put(key, values);
        }
        values.add(value);
    }

    public static String lastPathElement(String path) {
        if (path == null) {
            return null;
        }
        String[] elements = path.split("/");
        return elements[elements.length - 1];
    }

    public static ObjectId parseObjectId(String path) {
        Matcher matcher = OBJECTID_PATTERN.matcher(path);
        if (matcher.find()) {
            return new ObjectId(matcher.group(1));
        }
        throw new AtmosException("Cannot find object ID in path" + path);
    }

    public static Map<String, Metadata> parseMetadataHeader(String headerValue, boolean listable, boolean decodeUtf8) {
        String[] pairs;
        TreeMap<String, Metadata> metadataMap = new TreeMap<String, Metadata>();
        if (headerValue == null) {
            return metadataMap;
        }
        for (String pair : pairs = headerValue.split(",(?=[^,]+=)")) {
            String value;
            String[] components = pair.split("=", 2);
            String name = components[0].trim();
            if (decodeUtf8) {
                name = HttpUtil.decodeUtf8(name);
            }
            String string = value = components.length > 1 ? components[1] : null;
            if (value != null && decodeUtf8) {
                value = HttpUtil.decodeUtf8(value);
            }
            Metadata metadata = new Metadata(name, value, listable);
            metadataMap.put(name, metadata);
        }
        return metadataMap;
    }

    public static Map<String, Permission> parseAclHeader(String headerValue) {
        TreeMap<String, Permission> acl = new TreeMap<String, Permission>();
        if (headerValue == null || headerValue.trim().length() == 0) {
            return acl;
        }
        for (String pair : headerValue.split(",")) {
            String[] components = pair.split("=", 2);
            String name = components[0].trim();
            String permission = components[1];
            if ("FULL".equals(permission)) {
                permission = "FULL_CONTROL";
            }
            acl.put(name, Permission.valueOf(permission));
        }
        return acl;
    }

    private static String generateHashLine(Map<String, List<Object>> headers, String headerName) {
        String value = RestUtil.join((Iterable)headers.get(headerName), ",");
        l4j.debug((Object)(headerName + ": " + value));
        if (value != null) {
            return value + "\n";
        }
        return "\n";
    }

    private RestUtil() {
    }
}

