/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.mgmt.jersey;

import com.emc.atmos.AtmosException;
import com.emc.atmos.mgmt.AbstractMgmtConfig;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;

public class AuthFilter
extends ClientFilter {
    public static final String PROP_POX_REQUEST = AuthFilter.class.getName() + ".poxRequest";
    public static final String SESSION_COOKIE = "_gui_session_id";
    private AbstractMgmtConfig config;

    public AuthFilter(AbstractMgmtConfig config) {
        this.config = config;
    }

    @Override
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        if (request.getPropertyAsFeature(PROP_POX_REQUEST, false)) {
            return this.handlePox(request);
        }
        return this.handleRest(request);
    }

    private ClientResponse handleRest(ClientRequest request) {
        request.getHeaders().putAll(this.config.getRestAuthenticationHeaders());
        return this.getNext().handle(request);
    }

    private ClientResponse handlePox(ClientRequest request) throws ClientHandlerException {
        ClientResponse response;
        if (this.config.getSessionCookie() == null) {
            this.poxLogin(request);
        }
        this.attachSessionCookie(request);
        try {
            response = this.getNext().handle(request);
        }
        catch (AtmosException e) {
            if (e.getHttpCode() == 302) {
                this.invalidateCookie();
                this.poxLogin(request);
                this.attachSessionCookie(request);
                response = this.getNext().handle(request);
            }
            throw e;
        }
        return response;
    }

    private void attachSessionCookie(ClientRequest request) {
        request.getHeaders().putSingle((Object)"Cookie", (Object)new Cookie(SESSION_COOKIE, this.config.getSessionCookie()));
    }

    private synchronized void invalidateCookie() {
        this.config.setSessionCookie(null);
    }

    private synchronized void poxLogin(ClientRequest request) {
        if (this.config.getSessionCookie() != null) {
            return;
        }
        String holdMethod = request.getMethod();
        URI holdUri = request.getURI();
        Object holdEntity = request.getEntity();
        Object holdType = request.getHeaders().getFirst((Object)"Content-Type");
        Object holdAccept = request.getHeaders().getFirst((Object)"Accept");
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        for (Map.Entry<String, String> entry : this.config.getPoxLoginParams().entrySet()) {
            params.putSingle((Object)entry.getKey(), (Object)entry.getValue());
        }
        request.setMethod("POST");
        request.setURI(request.getURI().resolve(this.config.getPoxLoginPath()));
        request.setEntity(params);
        request.getHeaders().putSingle((Object)"Content-Type", (Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        request.getHeaders().putSingle((Object)"Accept", (Object)"application/xml");
        ClientResponse response = this.getNext().handle(request);
        String sessionCookie = null;
        for (NewCookie cookie : response.getCookies()) {
            if (!SESSION_COOKIE.equals(cookie.getName())) continue;
            sessionCookie = cookie.getValue();
            break;
        }
        if (sessionCookie == null) {
            throw new RuntimeException("Auth failure");
        }
        this.config.setSessionCookie(sessionCookie);
        request.setMethod(holdMethod);
        request.setURI(holdUri);
        request.setEntity(holdEntity);
        request.getHeaders().putSingle((Object)"Content-Type", holdType);
        request.getHeaders().putSingle((Object)"Accept", holdAccept);
    }
}

