/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.compression;

import com.emc.vipr.transform.compression.CompressionStream;
import com.emc.vipr.transform.encryption.KeyUtils;
import com.emc.vipr.transform.util.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class DeflateOutputStream
extends OutputStream
implements CompressionStream {
    private CountingOutputStream uncompressedCounter;
    private CountingOutputStream compressedCounter;
    private DigestOutputStream digester;
    private boolean closed;
    private byte[] uncompressedDigest;

    public DeflateOutputStream(OutputStream streamToCompress, int level) throws IOException {
        Deflater def = new Deflater(level);
        this.compressedCounter = new CountingOutputStream(streamToCompress);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)this.compressedCounter, def);
        this.uncompressedCounter = new CountingOutputStream(dos);
        try {
            this.digester = new DigestOutputStream(this.uncompressedCounter, MessageDigest.getInstance("SHA1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialize digest", e);
        }
        this.closed = false;
    }

    @Override
    public Map<String, String> getStreamMetadata() {
        if (!this.closed) {
            throw new IllegalStateException("Stream must be closed before getting metadata");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        long compSize = this.compressedCounter.getByteCount();
        long uncompSize = this.uncompressedCounter.getByteCount();
        String compRatioString = String.format("%.1f%%", 100.0 - (double)compSize * 100.0 / (double)uncompSize);
        metadata.put("x-emc-comp-uncompressed-size", "" + uncompSize);
        metadata.put("x-emc-comp-compressed-size", "" + compSize);
        metadata.put("x-emc-comp-compression-ratio", "" + compRatioString);
        metadata.put("x-emc-comp-uncompressed-sha1", KeyUtils.toHexPadded(this.uncompressedDigest));
        return metadata;
    }

    @Override
    public void write(int b) throws IOException {
        this.digester.write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.digester.close();
        this.uncompressedDigest = this.digester.getMessageDigest().digest();
    }

    @Override
    public void flush() throws IOException {
        this.digester.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.digester.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.digester.write(b);
    }
}

