/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api;

import com.emc.atmos.AtmosException;
import com.emc.atmos.api.ObjectIdentifier;
import com.emc.atmos.api.bean.DirectoryEntry;

public class ObjectPath
implements ObjectIdentifier {
    private String path;

    public ObjectPath(String path) {
        this.path = this.cleanPath(path);
    }

    public ObjectPath(ObjectPath parent, String path) {
        if (!parent.isDirectory()) {
            throw new AtmosException("parent path must be a directory (end with a slash)");
        }
        String parentPath = parent.getPath();
        this.path = parentPath.substring(0, parentPath.length() - 1) + this.cleanPath(path);
    }

    public ObjectPath(ObjectPath parent, DirectoryEntry directoryEntry) {
        this(parent, directoryEntry.getFilename() + (directoryEntry.isDirectory() ? "/" : ""));
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public String getRelativeResourcePath() {
        return "namespace" + this.path;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectPath that = (ObjectPath)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean isDirectory() {
        return this.path.charAt(this.path.length() - 1) == '/';
    }

    public String getFilename() {
        String[] levels = this.path.split("/");
        if (levels[levels.length - 1].length() == 0) {
            return levels[levels.length - 2];
        }
        return levels[levels.length - 1];
    }

    private String cleanPath(String path) {
        if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        return path;
    }
}

