/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RollbackDefinition;
import org.apache.camel.processor.RollbackProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;

public class RollbackReifier
extends ProcessorReifier<RollbackDefinition> {
    public RollbackReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (RollbackDefinition)definition);
    }

    @Override
    public Processor createProcessor() {
        boolean isMarkRollbackOnly = this.parseBoolean(((RollbackDefinition)this.definition).getMarkRollbackOnly(), false);
        boolean isMarkRollbackOnlyLast = this.parseBoolean(((RollbackDefinition)this.definition).getMarkRollbackOnlyLast(), false);
        if (isMarkRollbackOnly && isMarkRollbackOnlyLast) {
            throw new IllegalArgumentException("Only either one of markRollbackOnly and markRollbackOnlyLast is possible to select as true");
        }
        RollbackProcessor answer = new RollbackProcessor(((RollbackDefinition)this.definition).getMessage());
        answer.setMarkRollbackOnly(isMarkRollbackOnly);
        answer.setMarkRollbackOnlyLast(isMarkRollbackOnlyLast);
        return answer;
    }
}

