/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Ordered;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Service;
import org.apache.camel.StartupListener;
import org.apache.camel.support.service.ServiceHelper;

public class DeferServiceStartupListener
implements StartupListener,
Ordered {
    private final Set<Service> services = new CopyOnWriteArraySet<Service>();

    public void addService(Service service) {
        this.services.add(service);
    }

    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        while (!this.services.isEmpty()) {
            Service service = this.services.iterator().next();
            try {
                ServiceHelper.startService((Object)service);
            }
            catch (Exception e) {
                if (service instanceof Endpoint) {
                    Endpoint endpoint = (Endpoint)service;
                    throw new ResolveEndpointFailedException(endpoint.getEndpointUri(), (Throwable)e);
                }
                throw e;
            }
            finally {
                this.services.remove(service);
            }
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

