/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.IOHelper;

public class DefaultFactoryFinder
implements FactoryFinder {
    private final ConcurrentMap<String, Class<?>> classMap = new ConcurrentHashMap();
    private final ClassResolver classResolver;
    private final String path;

    public DefaultFactoryFinder(ClassResolver classResolver, String resourcePath) {
        this.classResolver = classResolver;
        this.path = resourcePath;
    }

    public String getResourcePath() {
        return this.path;
    }

    public Optional<Object> newInstance(String key) {
        return Optional.ofNullable(this.doNewInstance(key, null));
    }

    public <T> Optional<T> newInstance(String key, Class<T> type) {
        Object obj = this.doNewInstance(key, null);
        return Optional.ofNullable(type.cast(obj));
    }

    public Optional<Class<?>> findClass(String key) {
        return this.findClass(key, null);
    }

    public Optional<Class<?>> findClass(String key, String propertyPrefix) {
        String prefix = propertyPrefix != null ? propertyPrefix : "";
        String classKey = prefix + key;
        Class<?> clazz = this.addToClassMap(classKey, () -> {
            Properties prop = this.doFindFactoryProperties(key);
            if (prop != null) {
                return this.doNewInstance(prop, prefix, true).orElse(null);
            }
            return null;
        });
        return Optional.ofNullable(clazz);
    }

    public Optional<Class<?>> findClass(String key, String propertyPrefix, Class<?> clazz) {
        return this.findClass(key, propertyPrefix);
    }

    public Optional<Class<?>> findOptionalClass(String key, String propertyPrefix) {
        String prefix = propertyPrefix != null ? propertyPrefix : "";
        String classKey = prefix + key;
        Class<?> clazz = this.addToClassMap(classKey, () -> {
            Properties prop = this.doFindFactoryProperties(key);
            if (prop != null) {
                return this.doNewInstance(prop, prefix, false).orElse(null);
            }
            return null;
        });
        return Optional.ofNullable(clazz);
    }

    private Object doNewInstance(String key, String propertyPrefix) {
        Optional<Class<?>> clazz = this.findClass(key, propertyPrefix);
        return clazz.map(ObjectHelper::newInstance).orElse(null);
    }

    private Optional<Class<?>> doNewInstance(Properties properties, String propertyPrefix, boolean mandatory) throws IOException {
        String className = properties.getProperty(propertyPrefix + "class");
        if (className == null && mandatory) {
            throw new IOException("Expected property is missing: " + propertyPrefix + "class");
        }
        if (className == null) {
            return Optional.empty();
        }
        Class clazz = this.classResolver.resolveClass(className);
        return Optional.ofNullable(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties doFindFactoryProperties(String key) throws IOException {
        String uri = this.path + key;
        InputStream in = this.classResolver.loadResourceAsStream(uri);
        if (in == null) {
            return null;
        }
        BufferedInputStream reader = null;
        try {
            reader = IOHelper.buffered((InputStream)in);
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            IOHelper.close((Closeable)reader, (String)key, null);
            IOHelper.close((Closeable)in, (String)key, null);
        }
    }

    protected Class<?> addToClassMap(String key, final ClassSupplier mappingFunction) {
        return this.classMap.computeIfAbsent(key, new Function<String, Class<?>>(){

            @Override
            public Class<?> apply(String classKey) {
                try {
                    return mappingFunction.get();
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            }
        });
    }

    @FunctionalInterface
    protected static interface ClassSupplier {
        public Class<?> get() throws Exception;
    }
}

