/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.function.Function;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.PatternHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlTransient
public final class RouteFilters
implements Function<RouteDefinition, Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(RouteFilters.class);
    private final String includesText;
    private final String excludesText;
    private final String[] includes;
    private final String[] excludes;

    private RouteFilters(String include, String exclude) {
        this.includesText = include;
        this.excludesText = exclude;
        this.includes = include != null ? include.split(",") : null;
        this.excludes = exclude != null ? exclude.split(",") : null;
    }

    public static Function<RouteDefinition, Boolean> filterByPattern(String include, String exclude) {
        return new RouteFilters(include, exclude);
    }

    @Override
    public Boolean apply(RouteDefinition route) {
        String id = route.getId();
        String uri = route.getInput() != null ? route.getInput().getEndpointUri() : null;
        boolean answer = this.filter(route, id, uri);
        LOG.debug("Route filter: include={}, exclude={}, id={}, from={} -> {}", new Object[]{this.includesText, this.excludesText, id, uri, answer});
        return answer;
    }

    private boolean filter(RouteDefinition route, String id, String uri) {
        boolean match = false;
        if (this.excludes != null) {
            for (String part : this.excludes) {
                if (!PatternHelper.matchPattern((String)id, (String)part) && !PatternHelper.matchPattern((String)uri, (String)part)) continue;
                return false;
            }
        }
        if (this.includes != null) {
            for (String part : this.includes) {
                if (!PatternHelper.matchPattern((String)id, (String)part) && !PatternHelper.matchPattern((String)uri, (String)part)) continue;
                match = true;
                break;
            }
        } else {
            match = true;
        }
        return match;
    }
}

