/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.rfc4646.Lang;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ElementWrapper;
import org.apache.abdera.parser.stax.FOMException;
import org.apache.abdera.parser.stax.FOMFactory;
import org.apache.abdera.parser.stax.FOMWriter;
import org.apache.abdera.util.EntityTag;
import org.apache.abdera.util.XmlUtil;
import org.apache.abdera.writer.Writer;
import org.apache.abdera.writer.WriterOptions;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.llom.OMDocumentImpl;
import org.apache.axiom.om.util.StAXUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMDocument<T extends Element>
extends OMDocumentImpl
implements Document<T> {
    private static final long serialVersionUID = -3255339511063344662L;
    protected IRI base = null;
    protected MimeType contentType = null;
    protected Date lastModified = null;
    protected EntityTag etag = null;
    protected String language = null;
    protected String slug = null;
    protected boolean preserve = true;

    public FOMDocument() {
        super((OMFactory)new FOMFactory());
    }

    protected FOMDocument(OMFactory factory) {
        super(factory);
    }

    protected FOMDocument(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(parserWrapper, factory);
    }

    protected FOMDocument(OMXMLParserWrapper parserWrapper) {
        super(parserWrapper, (OMFactory)new FOMFactory());
    }

    public T getRoot() {
        FOMFactory factory = (FOMFactory)this.getFactory();
        return factory.getElementWrapper((Element)this.getOMDocumentElement());
    }

    public Document<T> setRoot(T root) {
        if (root instanceof OMElement) {
            this.setOMDocumentElement((OMElement)root);
        } else if (root instanceof ElementWrapper) {
            this.setOMDocumentElement((OMElement)((ElementWrapper)root).getInternal());
        }
        return this;
    }

    public IRI getBaseUri() {
        return this.base;
    }

    public Document<T> setBaseUri(String base) {
        this.base = new IRI(base);
        return this;
    }

    public void writeTo(OutputStream out, WriterOptions options) throws IOException {
        Writer writer = this.getFactory().getAbdera().getWriter();
        writer.writeTo((Base)this, out, options);
    }

    public void writeTo(java.io.Writer out, WriterOptions options) throws IOException {
        Writer writer = this.getFactory().getAbdera().getWriter();
        writer.writeTo((Base)this, out, options);
    }

    public void writeTo(Writer writer, OutputStream out) throws IOException {
        writer.writeTo((Base)this, out);
    }

    public void writeTo(Writer writer, java.io.Writer out) throws IOException {
        writer.writeTo((Base)this, out);
    }

    public void writeTo(Writer writer, OutputStream out, WriterOptions options) throws IOException {
        writer.writeTo((Base)this, out, options);
    }

    public void writeTo(Writer writer, java.io.Writer out, WriterOptions options) throws IOException {
        writer.writeTo((Base)this, out, options);
    }

    public void writeTo(OutputStream out) throws IOException {
        String charset = this.getCharset();
        if (charset == null) {
            charset = "UTF-8";
        }
        Writer writer = this.getFactory().getAbdera().getWriter();
        this.writeTo(writer, (java.io.Writer)new OutputStreamWriter(out, charset));
    }

    public void writeTo(java.io.Writer writer) throws IOException {
        Writer out = this.getFactory().getAbdera().getWriter();
        if (!(out instanceof FOMWriter)) {
            out.writeTo((Base)this, writer);
        } else {
            try {
                OMOutputFormat outputFormat = new OMOutputFormat();
                if (this.getCharsetEncoding() != null) {
                    outputFormat.setCharSetEncoding(this.getCharsetEncoding());
                }
                MTOMXMLStreamWriter omwriter = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((java.io.Writer)writer));
                omwriter.setOutputFormat(outputFormat);
                this.internalSerialize((XMLStreamWriter)omwriter);
                omwriter.flush();
            }
            catch (XMLStreamException e) {
                throw new FOMException(e);
            }
        }
    }

    public MimeType getContentType() {
        return this.contentType;
    }

    public Document<T> setContentType(String contentType) {
        try {
            this.contentType = new MimeType(contentType);
            if (this.contentType.getParameter("charset") != null) {
                this.setCharset(this.contentType.getParameter("charset"));
            }
        }
        catch (MimeTypeParseException e) {
            throw new org.apache.abdera.util.MimeTypeParseException(e);
        }
        return this;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public Document<T> setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public Object clone() {
        Document doc = ((FOMFactory)this.factory).newDocument();
        OMDocument omdoc = (OMDocument)doc;
        Iterator i = this.getChildren();
        while (i.hasNext()) {
            OMNode node = (OMNode)i.next();
            switch (node.getType()) {
                case 5: {
                    OMComment comment = (OMComment)node;
                    this.factory.createOMComment((OMContainer)omdoc, comment.getValue());
                    break;
                }
                case 1: {
                    Element el = (Element)node;
                    omdoc.addChild((OMNode)el.clone());
                    break;
                }
                case 3: {
                    OMProcessingInstruction pi = (OMProcessingInstruction)node;
                    this.factory.createOMProcessingInstruction((OMContainer)omdoc, pi.getTarget(), pi.getValue());
                }
            }
        }
        return doc;
    }

    public String getCharset() {
        return this.getCharsetEncoding();
    }

    public Document<T> setCharset(String charset) {
        this.setCharsetEncoding(charset);
        return this;
    }

    public Factory getFactory() {
        return (Factory)this.factory;
    }

    public String[] getProcessingInstruction(String target) {
        ArrayList<String> values = new ArrayList<String>();
        Iterator i = this.getChildren();
        while (i.hasNext()) {
            OMProcessingInstruction pi;
            OMNode node = (OMNode)i.next();
            if (node.getType() != 3 || !(pi = (OMProcessingInstruction)node).getTarget().equalsIgnoreCase(target)) continue;
            values.add(pi.getValue());
        }
        return values.toArray(new String[values.size()]);
    }

    public Document<T> addProcessingInstruction(String target, String value) {
        OMProcessingInstruction pi = this.factory.createOMProcessingInstruction(null, target, value);
        if (this.getOMDocumentElement() != null) {
            this.getOMDocumentElement().insertSiblingBefore((OMNode)pi);
        } else {
            this.addChild((OMNode)pi);
        }
        return this;
    }

    public Document<T> addStylesheet(String href, String media) {
        if (media == null) {
            this.addProcessingInstruction("xml-stylesheet", "href=\"" + href + "\"");
        } else {
            this.addProcessingInstruction("xml-stylesheet", "href=\"" + href + "\" media=\"" + media + "\"");
        }
        return this;
    }

    public <X extends Base> X addComment(String value) {
        OMComment comment = this.factory.createOMComment(null, value);
        if (this.getOMDocumentElement() != null) {
            this.getOMDocumentElement().insertSiblingBefore((OMNode)comment);
        } else {
            this.addChild((OMNode)comment);
        }
        return (X)((Object)this);
    }

    public EntityTag getEntityTag() {
        return this.etag;
    }

    public Document<T> setEntityTag(EntityTag tag) {
        this.etag = tag;
        return this;
    }

    public Document<T> setEntityTag(String tag) {
        this.etag = new EntityTag(tag);
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Lang getLanguageTag() {
        String lang = this.getLanguage();
        return lang != null ? new Lang(lang) : null;
    }

    public Document<T> setLanguage(String lang) {
        this.language = lang;
        return this;
    }

    public String getSlug() {
        return this.slug;
    }

    public Document<T> setSlug(String slug) {
        this.slug = slug;
        return this;
    }

    public boolean getMustPreserveWhitespace() {
        return this.preserve;
    }

    public Document<T> setMustPreserveWhitespace(boolean preserve) {
        this.preserve = preserve;
        return this;
    }

    public XmlUtil.XMLVersion getXmlVersion() {
        return XmlUtil.getVersion((String)super.getXMLVersion());
    }

    public WriterOptions getDefaultWriterOptions() {
        return new FOMWriter().getDefaultWriterOptions();
    }

    public <X extends Base> X complete() {
        if (!this.isComplete() && this.getRoot() != null) {
            this.getRoot().complete();
        }
        return (X)((Object)this);
    }

    public void writeTo(String writer, OutputStream out) throws IOException {
        this.writeTo(this.getFactory().getAbdera().getWriterFactory().getWriter(writer), out);
    }

    public void writeTo(String writer, java.io.Writer out) throws IOException {
        this.writeTo(this.getFactory().getAbdera().getWriterFactory().getWriter(writer), out);
    }

    public void writeTo(String writer, OutputStream out, WriterOptions options) throws IOException {
        this.writeTo(this.getFactory().getAbdera().getWriterFactory().getWriter(writer), out, options);
    }

    public void writeTo(String writer, java.io.Writer out, WriterOptions options) throws IOException {
        this.writeTo(this.getFactory().getAbdera().getWriterFactory().getWriter(writer), out, options);
    }

    public String toFormattedString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeTo("prettyxml", (OutputStream)out);
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            return ((Object)((Object)this)).toString();
        }
    }
}

