/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.awss3.transformers;

import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.util.Map;
import org.apache.camel.kafkaconnector.awss3.serializers.S3ObjectSerializer;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;

public class S3ObjectTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("test", ConfigDef.Type.STRING, (Object)"test", ConfigDef.Importance.MEDIUM, "Transform the content of a bucket into a string ");
    private final S3ObjectSerializer serializer = new S3ObjectSerializer();

    public void configure(Map<String, ?> configs) {
    }

    public R apply(R record) {
        byte[] v = this.serializer.serialize(record.topic(), (S3ObjectInputStream)record.value());
        String finalValue = new String(v);
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), null, record.key(), Schema.STRING_SCHEMA, (Object)finalValue, record.timestamp());
    }

    public void close() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }
}

