/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.aws2kinesis.transformers;

import java.util.Map;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.Record;

public class KinesisRecordDataTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String FIELD_KEY_CONFIG = "key";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("key", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Transforms Kinesis Data to String");
    private static final Logger LOG = LoggerFactory.getLogger(KinesisRecordDataTransforms.class);

    public R apply(R r) {
        Object value = r.value();
        if (value instanceof Record) {
            LOG.debug("Converting record from Data to String");
            Record message = (Record)r.value();
            String payload = new String(message.data().asByteArray());
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), null, r.key(), (Schema)SchemaHelper.buildSchemaBuilderForType((Object)payload), (Object)payload, r.timestamp());
        }
        LOG.debug("Unexpected message type: {}", r.value().getClass());
        return r;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }
}

