/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.aws2s3.transformers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import org.apache.camel.kafkaconnector.aws2s3.models.StorageRecord;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.transforms.Transformation;

public class JSONToRecordTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String FIELD_KEY_CONFIG = "key";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("key", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Add the key and the header to the record value");

    public void configure(Map<String, ?> configs) {
    }

    public R apply(R record) {
        String str = new String((byte[])record.value());
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        StorageRecord storageRecord = (StorageRecord)gson.fromJson(str, StorageRecord.class);
        ConnectHeaders headers = new ConnectHeaders();
        for (int i = 0; i < storageRecord.headers.length; ++i) {
            headers.add(storageRecord.headers[i].key, (Object)storageRecord.headers[i].value, null);
        }
        headers.forEach(h -> record.headers().add(h));
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), (Object)storageRecord.key, record.valueSchema(), (Object)storageRecord.body, record.timestamp(), (Iterable)headers);
    }

    public void close() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }
}

