/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.aws2s3.serializers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;

public class S3ObjectSerializer
implements Serializer<ResponseInputStream> {
    private static final Logger LOG = LoggerFactory.getLogger(S3ObjectSerializer.class);

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, ResponseInputStream data) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] byteArray = new byte[16384];
        try {
            int nRead;
            while ((nRead = data.read(byteArray, 0, byteArray.length)) != -1) {
                buffer.write(byteArray, 0, nRead);
            }
        }
        catch (IOException e) {
            LOG.warn("I/O error while serializing data from or to topic {}: {} | {}", new Object[]{topic, e.getMessage(), e});
        }
        return buffer.toByteArray();
    }

    public void close() {
    }
}

