/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.aws2sqs.transformers;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.Transformation;

public class SQSKeySetterTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("test", ConfigDef.Type.STRING, (Object)"test", ConfigDef.Importance.MEDIUM, "Fetch the Camel.CamelAwsSqsMessageId header and set it as the key for the kafka record");

    public R apply(R record) {
        Headers headers = record.headers();
        String key = (String)headers.lastWithName("CamelHeader.CamelAwsSqsMessageId").value();
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), null, (Object)key, Schema.STRING_SCHEMA, record.value(), record.timestamp());
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }
}

