/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxCollectionIterator;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxItemIterator;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.PartialCollection;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Iterator;

@BoxResourceType(value="collection")
public class BoxCollection
extends BoxResource
implements Iterable<BoxItem.Info> {
    public static final URLTemplate GET_COLLECTIONS_URL_TEMPLATE = new URLTemplate("collections/");
    public static final URLTemplate GET_COLLECTION_ITEMS_URL = new URLTemplate("collections/%s/items/");

    public BoxCollection(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Iterable<Info> getAllCollections(final BoxAPIConnection api) {
        return new Iterable<Info>(){

            @Override
            public Iterator<Info> iterator() {
                URL url = GET_COLLECTIONS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
                return new BoxCollectionIterator(api, url);
            }
        };
    }

    public Iterable<BoxItem.Info> getItems() {
        return this;
    }

    public Iterable<BoxItem.Info> getItems(final String ... fields) {
        return new Iterable<BoxItem.Info>(){

            @Override
            public Iterator<BoxItem.Info> iterator() {
                String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
                URL url = GET_COLLECTION_ITEMS_URL.buildWithQuery(BoxCollection.this.getAPI().getBaseURL(), queryString, BoxCollection.this.getID());
                return new BoxItemIterator(BoxCollection.this.getAPI(), url);
            }
        };
    }

    public PartialCollection<BoxItem.Info> getItemsRange(long offset, long limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder().appendParam("offset", offset).appendParam("limit", limit);
        if (fields.length > 0) {
            builder.appendParam("fields", fields).toString();
        }
        URL url = GET_COLLECTION_ITEMS_URL.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        String totalCountString = responseJSON.get("total_count").toString();
        long fullSize = Double.valueOf(totalCountString).longValue();
        PartialCollection<BoxItem.Info> items = new PartialCollection<BoxItem.Info>(offset, limit, fullSize);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxItem.Info entryInfo = (BoxItem.Info)BoxResource.parseInfo(this.getAPI(), entry.asObject());
            if (entryInfo == null) continue;
            items.add(entryInfo);
        }
        return items;
    }

    @Override
    public Iterator<BoxItem.Info> iterator() {
        URL url = GET_COLLECTION_ITEMS_URL.build(this.getAPI().getBaseURL(), this.getID());
        return new BoxItemIterator(this.getAPI(), url);
    }

    public class Info
    extends BoxResource.Info {
        private String collectionType;
        private String name;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        public String getCollectionType() {
            return this.collectionType;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public BoxCollection getResource() {
            return BoxCollection.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            if (memberName.equals("collection_type")) {
                this.collectionType = value.asString();
            } else if (memberName.equals("name")) {
                this.name = value.asString();
            }
        }
    }
}

