/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.Metadata;
import com.box.sdk.ProgressListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.camel.component.box.api.BoxFilesManager;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

public enum BoxFilesManagerApiMethod implements ApiMethod
{
    CHECKUPLOAD(Void.TYPE, "checkUpload", ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"parentFolderId", String.class), ApiMethodArg.arg((String)"size", Long.class)),
    COPYFILE(BoxFile.class, "copyFile", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"destinationFolderId", String.class), ApiMethodArg.arg((String)"newName", String.class)),
    CREATEFILEMETADATA(Metadata.class, "createFileMetadata", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"metadata", Metadata.class), ApiMethodArg.arg((String)"typeName", String.class)),
    CREATEFILESHAREDLINK(BoxSharedLink.class, "createFileSharedLink", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"access", BoxSharedLink.Access.class), ApiMethodArg.arg((String)"unshareDate", Date.class), ApiMethodArg.arg((String)"permissions", BoxSharedLink.Permissions.class)),
    DELETEFILE(Void.TYPE, "deleteFile", ApiMethodArg.arg((String)"fileId", String.class)),
    DELETEFILEMETADATA(Void.TYPE, "deleteFileMetadata", ApiMethodArg.arg((String)"fileId", String.class)),
    DELETEFILEVERSION(Void.TYPE, "deleteFileVersion", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"version", Integer.class)),
    DOWNLOADFILE(OutputStream.class, "downloadFile", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"output", OutputStream.class), ApiMethodArg.arg((String)"rangeStart", Long.class), ApiMethodArg.arg((String)"rangeEnd", Long.class), ApiMethodArg.arg((String)"listener", ProgressListener.class)),
    DOWNLOADPREVIOUSFILEVERSION(OutputStream.class, "downloadPreviousFileVersion", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"version", Integer.class), ApiMethodArg.arg((String)"output", OutputStream.class), ApiMethodArg.arg((String)"listener", ProgressListener.class)),
    GETDOWNLOADURL(URL.class, "getDownloadURL", ApiMethodArg.arg((String)"fileId", String.class)),
    GETFILEINFO(BoxFile.Info.class, "getFileInfo", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"fields", new String[0].getClass())),
    GETFILEMETADATA(Metadata.class, "getFileMetadata", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"typeName", String.class)),
    GETFILEPREVIEWLINK(URL.class, "getFilePreviewLink", ApiMethodArg.arg((String)"fileId", String.class)),
    GETFILETHUMBNAIL(new byte[0].getClass(), "getFileThumbnail", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"fileType", BoxFile.ThumbnailFileType.class), ApiMethodArg.arg((String)"minWidth", Integer.class), ApiMethodArg.arg((String)"minHeight", Integer.class), ApiMethodArg.arg((String)"maxWidth", Integer.class), ApiMethodArg.arg((String)"maxHeight", Integer.class)),
    GETFILEVERSIONS(Collection.class, "getFileVersions", ApiMethodArg.arg((String)"fileId", String.class)),
    MOVEFILE(BoxFile.class, "moveFile", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"destinationFolderId", String.class), ApiMethodArg.arg((String)"newName", String.class)),
    PROMOTEFILEVERSION(BoxFileVersion.class, "promoteFileVersion", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"version", Integer.class)),
    RENAMEFILE(BoxFile.class, "renameFile", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"newFileName", String.class)),
    UPDATEFILEINFO(BoxFile.class, "updateFileInfo", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"info", BoxFile.Info.class)),
    UPDATEFILEMETADATA(Metadata.class, "updateFileMetadata", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"metadata", Metadata.class)),
    UPLOADFILE(BoxFile.class, "uploadFile", ApiMethodArg.arg((String)"parentFolderId", String.class), ApiMethodArg.arg((String)"content", InputStream.class), ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"created", Date.class), ApiMethodArg.arg((String)"modified", Date.class), ApiMethodArg.arg((String)"size", Long.class), ApiMethodArg.arg((String)"check", Boolean.class), ApiMethodArg.arg((String)"listener", ProgressListener.class)),
    UPLOADNEWFILEVERSION(BoxFile.class, "uploadNewFileVersion", ApiMethodArg.arg((String)"fileId", String.class), ApiMethodArg.arg((String)"fileContent", InputStream.class), ApiMethodArg.arg((String)"modified", Date.class), ApiMethodArg.arg((String)"fileSize", Long.class), ApiMethodArg.arg((String)"listener", ProgressListener.class));

    private final ApiMethod apiMethod;

    private BoxFilesManagerApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(BoxFilesManager.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

