/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.sdk.BoxAPIConnection;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.BoxEndpoint;
import org.apache.camel.component.box.internal.BoxApiCollection;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.component.box.internal.BoxConnectionHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;

@Component(value="box")
public class BoxComponent
extends AbstractApiComponent<BoxApiName, BoxConfiguration, BoxApiCollection> {
    @Metadata
    BoxConfiguration configuration;
    @Metadata(label="advanced")
    BoxAPIConnection boxConnection;

    public BoxComponent() {
        super(BoxEndpoint.class, BoxApiName.class, (ApiCollection)BoxApiCollection.getCollection());
    }

    public BoxComponent(CamelContext context) {
        super(context, BoxEndpoint.class, BoxApiName.class, (ApiCollection)BoxApiCollection.getCollection());
    }

    protected BoxApiName getApiName(String apiNameStr) {
        return (BoxApiName)((Object)this.getCamelContext().getTypeConverter().convertTo(BoxApiName.class, (Object)apiNameStr));
    }

    public void setConfiguration(BoxConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public BoxConfiguration getConfiguration() {
        return (BoxConfiguration)super.getConfiguration();
    }

    public BoxAPIConnection getBoxConnection() {
        return this.boxConnection;
    }

    protected Endpoint createEndpoint(String uri, String methodName, BoxApiName apiName, BoxConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new BoxEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.boxConnection == null) {
            if (this.getConfiguration() != null) {
                this.boxConnection = BoxConnectionHelper.createConnection(this.getConfiguration());
            } else {
                throw new IllegalArgumentException("Unable to connect, Box component configuration is missing");
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.boxConnection != null) {
            this.boxConnection = null;
        }
    }

    public void doShutdown() throws Exception {
        if (this.boxConnection != null) {
            this.boxConnection = null;
        }
        super.doShutdown();
    }
}

