/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.FilterArgs;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefangFilter
extends BasicFilter
implements ChunkFilter {
    private static final Pattern NOT_HARMLESS_CHAR = Pattern.compile("[^A-Za-z0-9@\\!\\?\\*\\#\\$\\(\\)\\+\\=\\:\\;\\,\\~\\/\\._-]");

    public String transformText(Chunk chunk, String text, FilterArgs args) {
        return text == null ? null : DefangFilter.defang(text);
    }

    public String getFilterName() {
        return "defang";
    }

    public String[] getFilterAliases() {
        return new String[]{"noxss", "neuter"};
    }

    private static String defang(String text) {
        if (text == null) {
            return null;
        }
        Matcher m = NOT_HARMLESS_CHAR.matcher(text);
        return m.replaceAll("");
    }
}

