/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.main.MainShutdownStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMainShutdownStrategy
implements MainShutdownStrategy {
    protected static final Logger LOG = LoggerFactory.getLogger(SimpleMainShutdownStrategy.class);
    private final Set<MainShutdownStrategy.ShutdownEventListener> listeners = new LinkedHashSet<MainShutdownStrategy.ShutdownEventListener>();
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public boolean isRunAllowed() {
        return !this.completed.get();
    }

    @Override
    public void addShutdownListener(MainShutdownStrategy.ShutdownEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean shutdown() {
        if (this.completed.compareAndSet(false, true)) {
            LOG.debug("Setting shutdown completed state from false to true");
            this.latch.countDown();
            for (MainShutdownStrategy.ShutdownEventListener l : this.listeners) {
                try {
                    LOG.trace("ShutdownEventListener: {}", (Object)l);
                    l.onShutdown();
                }
                catch (Throwable e) {
                    LOG.debug("Error during ShutdownEventListener: {}. This exception is ignored.", (Object)l, (Object)e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void await() throws InterruptedException {
        LOG.debug("Await shutdown to complete");
        this.latch.await();
    }

    @Override
    public void await(long timeout, TimeUnit unit) throws InterruptedException {
        LOG.debug("Await shutdown to complete with timeout: {} {}", (Object)timeout, (Object)unit);
        this.latch.await(timeout, unit);
    }
}

