/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HelloExtension;

public class SupportedPointFormatsExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 8;
    private static final int POINT_FORMAT_BITS = 8;
    List<ECPointFormat> ecPointFormatList;

    public SupportedPointFormatsExtension(List<ECPointFormat> ecPointFormatList) {
        super(HelloExtension.ExtensionType.EC_POINT_FORMATS);
        this.ecPointFormatList = ecPointFormatList;
    }

    public void addECPointFormat(ECPointFormat format) {
        this.ecPointFormatList.add(format);
    }

    public boolean contains(ECPointFormat format) {
        return this.ecPointFormatList.contains((Object)format);
    }

    @Override
    public int getLength() {
        return 5 + this.ecPointFormatList.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\t\t\tLength: ").append(this.getLength() - 4);
        sb.append(StringUtil.lineSeparator()).append("\t\t\t\tEC point formats length: ").append(this.getLength() - 5);
        sb.append(StringUtil.lineSeparator()).append("\t\t\t\tElliptic Curves Point Formats (").append(this.ecPointFormatList.size()).append("):");
        for (ECPointFormat format : this.ecPointFormatList) {
            sb.append(StringUtil.lineSeparator()).append("\t\t\t\t\tEC point format: ").append(format.toString());
        }
        return sb.toString();
    }

    @Override
    protected void addExtensionData(DatagramWriter writer) {
        int listLength = this.ecPointFormatList.size();
        writer.write(listLength + 1, 16);
        writer.write(listLength, 8);
        for (ECPointFormat format : this.ecPointFormatList) {
            writer.write(format.getId(), 8);
        }
    }

    public static HelloExtension fromExtensionDataReader(DatagramReader extensionDataReader) {
        ArrayList<ECPointFormat> ecPointFormatList = new ArrayList<ECPointFormat>();
        int listLength = extensionDataReader.read(8);
        DatagramReader rangeReader = extensionDataReader.createRangeReader(listLength);
        while (rangeReader.bytesAvailable()) {
            ECPointFormat format = ECPointFormat.getECPointFormatById(rangeReader.read(8));
            ecPointFormatList.add(format);
        }
        return new SupportedPointFormatsExtension(ecPointFormatList);
    }

    public static enum ECPointFormat {
        UNCOMPRESSED(0),
        ANSIX962_COMPRESSED_PRIME(1),
        ANSIX962_COMPRESSED_CHAR2(2);

        private int id;

        private ECPointFormat(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            switch (this.id) {
                case 0: {
                    return "uncompressed (" + this.id + ")";
                }
                case 1: {
                    return "ansiX962_compressed_prime (" + this.id + ")";
                }
                case 2: {
                    return "ansiX962_compressed_char2 (" + this.id + ")";
                }
            }
            return "";
        }

        public static ECPointFormat getECPointFormatById(int id) {
            switch (id) {
                case 0: {
                    return UNCOMPRESSED;
                }
                case 1: {
                    return ANSIX962_COMPRESSED_PRIME;
                }
                case 2: {
                    return ANSIX962_COMPRESSED_CHAR2;
                }
            }
            return null;
        }
    }
}

