/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.auth.AdvancedApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.GenericHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeParameter;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ReassemblingHandshakeMessage;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.rpkstore.TrustedRpkStore;
import org.eclipse.californium.scandium.dtls.x509.AdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.CertificateVerifier;
import org.eclipse.californium.scandium.util.SecretIvParameterSpec;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Handshaker
implements Destroyable {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final boolean isClient;
    protected ProtocolVersion usedProtocol;
    protected Random clientRandom;
    protected Random serverRandom;
    protected SecretKey masterSecret;
    private SecretKey clientWriteMACKey;
    private SecretKey serverWriteMACKey;
    private SecretKey clientWriteKey;
    private SecretKey serverWriteKey;
    private SecretIvParameterSpec clientWriteIV;
    private SecretIvParameterSpec serverWriteIV;
    private boolean destroyed;
    private final ReentrantLock recursionProtection = new ReentrantLock();
    protected final DTLSSession session;
    protected final CertificateVerifier certificateVerifier;
    protected final TrustedRpkStore rpkStore;
    protected final AdvancedPskStore advancedPskStore;
    protected final ConnectionIdGenerator connectionIdGenerator;
    private int sendMessageSequence = 0;
    private int nextReceiveMessageSequence = 0;
    private boolean lastFlight;
    private long flightSendNanos;
    private long nanosExpireTime;
    private final long nanosExpireTimeout;
    protected int flightNumber = 0;
    private int deferredRecordsSize;
    private final int maxFragmentedHandshakeMessageLength;
    private final int maxDeferredProcessedOutgoingApplicationDataMessages;
    private final int maxDeferredProcessedIncomingRecordsSize;
    private final List<RawData> deferredApplicationData = new ArrayList<RawData>();
    private final List<Record> deferredRecords = new ArrayList<Record>();
    private final AtomicReference<DTLSFlight> pendingFlight = new AtomicReference();
    private final RecordLayer recordLayer;
    private final Connection connection;
    private InboundMessageBuffer inboundMessageBuffer;
    protected final List<HandshakeMessage> handshakeMessages = new ArrayList<HandshakeMessage>();
    protected ReassemblingHandshakeMessage reassembledMessage;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected List<X509Certificate> certificateChain;
    protected CertPath peerCertPath;
    protected boolean sniEnabled;
    protected boolean useStateValidation;
    protected final boolean useKeyUsageVerification;
    protected final boolean useTruncatedCertificatePathForVerification;
    private final Set<SessionListener> sessionListeners = new LinkedHashSet<SessionListener>();
    protected int statesIndex;
    protected HandshakeState[] states;
    private boolean changeCipherSuiteMessageExpected = false;
    private boolean sessionEstablished = false;
    private boolean handshakeAborted = false;
    private boolean handshakeFailed = false;
    private boolean pskRequestPending = false;
    private SecretKey otherSecret;
    private Throwable cause;
    private Object customArgument;
    private ApplicationLevelInfoSupplier applicationLevelInfoSupplier;

    protected Handshaker(boolean isClient, int initialMessageSeq, DTLSSession session, RecordLayer recordLayer, Connection connection, DtlsConnectorConfig config, int maxTransmissionUnit) {
        if (session == null) {
            throw new NullPointerException("DTLS Session must not be null");
        }
        if (recordLayer == null) {
            throw new NullPointerException("Record layer must not be null");
        }
        if (connection == null) {
            throw new NullPointerException("Connection must not be null");
        }
        if (config == null) {
            throw new NullPointerException("Dtls Connector Config must not be null");
        }
        if (initialMessageSeq < 0) {
            throw new IllegalArgumentException("Initial message sequence number must not be negative");
        }
        this.isClient = isClient;
        this.sendMessageSequence = initialMessageSeq;
        this.nextReceiveMessageSequence = initialMessageSeq;
        this.session = session;
        this.recordLayer = recordLayer;
        this.connection = connection;
        this.connectionIdGenerator = config.getConnectionIdGenerator();
        this.maxFragmentedHandshakeMessageLength = config.getMaxFragmentedHandshakeMessageLength();
        this.maxDeferredProcessedOutgoingApplicationDataMessages = config.getMaxDeferredProcessedOutgoingApplicationDataMessages();
        this.maxDeferredProcessedIncomingRecordsSize = config.getMaxDeferredProcessedIncomingRecordsSize();
        this.sniEnabled = config.isSniEnabled();
        this.useStateValidation = config.useHandshakeStateValidation();
        this.useKeyUsageVerification = config.useKeyUsageVerification();
        this.useTruncatedCertificatePathForVerification = config.useTruncatedCertificatePathForValidation();
        this.privateKey = config.getPrivateKey();
        this.publicKey = config.getPublicKey();
        this.certificateChain = config.getCertificateChain();
        this.certificateVerifier = config.getCertificateVerifier();
        this.rpkStore = config.getRpkTrustStore();
        this.advancedPskStore = config.getAdvancedPskStore();
        this.session.setMaxTransmissionUnit(maxTransmissionUnit);
        this.applicationLevelInfoSupplier = config.getApplicationLevelInfoSupplier();
        this.inboundMessageBuffer = new InboundMessageBuffer();
        int max = config.getMaxRetransmissions();
        int timeoutMillis = config.getRetransmissionTimeout();
        int expireTimeoutMillis = timeoutMillis * 2;
        for (int retry = 0; retry < max; ++retry) {
            timeoutMillis = DTLSFlight.incrementTimeout(timeoutMillis);
            expireTimeoutMillis += timeoutMillis;
        }
        this.nanosExpireTimeout = TimeUnit.MILLISECONDS.toNanos(expireTimeoutMillis);
        this.addSessionListener(connection.getSessionListener());
    }

    private static int compareRecords(Record r1, Record r2) {
        if (r1.getEpoch() != r2.getEpoch()) {
            throw new IllegalArgumentException("records with different epoch! " + r1.getEpoch() + " != " + r2.getEpoch());
        }
        HandshakeMessage h1 = (HandshakeMessage)r1.getFragment();
        HandshakeMessage h2 = (HandshakeMessage)r2.getFragment();
        if (h1.getMessageSeq() < h2.getMessageSeq()) {
            return -1;
        }
        if (h1.getMessageSeq() > h2.getMessageSeq()) {
            return 1;
        }
        if (r1.getSequenceNumber() < r2.getSequenceNumber()) {
            return -1;
        }
        if (r1.getSequenceNumber() > r2.getSequenceNumber()) {
            return 1;
        }
        return 0;
    }

    public boolean isInboundMessageProcessed() {
        return this.inboundMessageBuffer.isEmpty();
    }

    public final void processMessage(Record record) throws HandshakeException {
        int epoch = this.session.getReadEpoch();
        if (epoch != record.getEpoch()) {
            this.LOGGER.debug("Discarding {} message with wrong epoch received from peer [{}]:{}{}", new Object[]{record.getType(), record.getPeerAddress(), StringUtil.lineSeparator(), record});
            throw new IllegalArgumentException("processing record with wrong epoch! " + record.getEpoch() + " expected " + epoch);
        }
        if (record.getReceiveNanos() < this.flightSendNanos) {
            this.LOGGER.info("Discarding {} message received from peer [{}] before last flight was sent:{}{}", new Object[]{record.getType(), record.getPeerAddress(), StringUtil.lineSeparator(), record});
            return;
        }
        Record recordToProcess = this.inboundMessageBuffer.getNextRecord(record);
        if (recordToProcess != null) {
            this.processNextMessages(recordToProcess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextMessages(Record record) throws HandshakeException {
        if (this.recursionProtection.isHeldByCurrentThread()) {
            this.LOGGER.warn("Called from doProcessMessage, return immediately to process next message!", new Throwable("recursion-protection"));
            return;
        }
        try {
            Record recordToProcess;
            int epoch = this.session.getReadEpoch();
            int counter = 0;
            Record record2 = recordToProcess = record != null ? record : this.inboundMessageBuffer.getNextRecord();
            while (recordToProcess != null) {
                DTLSMessage messageToProcess = recordToProcess.getFragment();
                this.expectMessage(messageToProcess);
                if (messageToProcess.getContentType() == ContentType.CHANGE_CIPHER_SPEC) {
                    this.LOGGER.debug("Processing {} message from peer [{}]", (Object)messageToProcess.getContentType(), (Object)messageToProcess.getPeer());
                    this.setCurrentReadState();
                    ++this.statesIndex;
                    this.LOGGER.debug("Processed {} message from peer [{}]", (Object)messageToProcess.getContentType(), (Object)messageToProcess.getPeer());
                } else if (messageToProcess.getContentType() == ContentType.HANDSHAKE) {
                    HandshakeMessage handshakeMessage = (HandshakeMessage)messageToProcess;
                    if (handshakeMessage.getMessageType() == HandshakeType.FINISHED && epoch == 0) {
                        this.LOGGER.debug("FINISH with epoch 0 from peer [{}]!", (Object)this.getSession().getPeer());
                        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, this.getSession().getPeer());
                        throw new HandshakeException("FINISH with epoch 0!", alert);
                    }
                    DTLSFlight flight = this.pendingFlight.get();
                    if (flight != null) {
                        this.LOGGER.debug("response for flight {} started", (Object)flight.getFlightNumber());
                        flight.setResponseStarted();
                    }
                    if (handshakeMessage instanceof FragmentedHandshakeMessage) {
                        handshakeMessage = this.handleFragmentation((FragmentedHandshakeMessage)handshakeMessage);
                    }
                    if (handshakeMessage != null) {
                        if (handshakeMessage instanceof GenericHandshakeMessage) {
                            GenericHandshakeMessage genericMessage = (GenericHandshakeMessage)handshakeMessage;
                            HandshakeParameter parameter = this.session.getParameter();
                            if (parameter == null) {
                                this.LOGGER.warn("Cannot process handshake {} message from peer [{}], parameter are required!", (Object)genericMessage.getMessageType(), (Object)this.getSession().getPeer());
                                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer());
                                throw new HandshakeException("Cannot process " + (Object)((Object)genericMessage.getMessageType()) + " handshake message, parameter are required!", alert);
                            }
                            handshakeMessage = genericMessage.getSpecificHandshakeMessage(parameter);
                        }
                        if (this.lastFlight) {
                            if (flight == null) {
                                if (this.cause != null) {
                                    this.LOGGER.error("last flight missing, handshake already failed! {}", (Object)handshakeMessage, (Object)this.cause);
                                    break;
                                }
                                if (counter == 0) {
                                    this.LOGGER.error("last flight missing, resend failed! {}", (Object)handshakeMessage);
                                    break;
                                }
                                this.LOGGER.error("last flight missing, resend for buffered message {} failed! {}", (Object)counter, (Object)handshakeMessage);
                                break;
                            }
                            this.LOGGER.debug("Received ({}) FINISHED message again, retransmitting last flight...", (Object)this.getPeerAddress());
                            flight.incrementTries();
                            flight.setNewSequenceNumbers();
                            this.sendFlight(flight);
                        } else {
                            if (this.LOGGER.isDebugEnabled()) {
                                StringBuilder msg = new StringBuilder();
                                msg.append(String.format("Processing %s message from peer [%s], seqn: [%d]", new Object[]{handshakeMessage.getMessageType(), handshakeMessage.getPeer(), handshakeMessage.getMessageSeq()}));
                                if (this.LOGGER.isTraceEnabled()) {
                                    msg.append(":").append(StringUtil.lineSeparator()).append(handshakeMessage);
                                }
                                this.LOGGER.debug(msg.toString());
                            }
                            if (epoch == 0) {
                                this.handshakeMessages.add(handshakeMessage);
                            }
                            this.recursionProtection.lock();
                            try {
                                this.doProcessMessage(handshakeMessage);
                            }
                            finally {
                                this.recursionProtection.unlock();
                            }
                            this.LOGGER.debug("Processed {} message from peer [{}]", (Object)handshakeMessage.getMessageType(), (Object)handshakeMessage.getPeer());
                            if (!this.lastFlight) {
                                ++this.nextReceiveMessageSequence;
                                ++this.statesIndex;
                            }
                        }
                    }
                } else {
                    throw new HandshakeException(String.format("Received unexpected message [%s] from peer %s", new Object[]{messageToProcess.getContentType(), messageToProcess.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, messageToProcess.getPeer()));
                }
                this.session.markRecordAsRead(epoch, recordToProcess.getSequenceNumber());
                this.inboundMessageBuffer.clean(recordToProcess.getSequenceNumber());
                recordToProcess = this.inboundMessageBuffer.getNextRecord();
                ++counter;
            }
            if (this.session.getReadEpoch() > epoch) {
                SerialExecutor serialExecutor = this.connection.getExecutor();
                List<Record> records = this.takeDeferredRecords();
                if (this.deferredRecordsSize > 0) {
                    throw new HandshakeException(String.format("Received unexpected message left from peer %s", record.getPeerAddress()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, record.getPeerAddress()));
                }
                for (Record deferredRecord : records) {
                    if (serialExecutor != null) {
                        final Record dRecord = deferredRecord;
                        serialExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                Handshaker.this.recordLayer.processRecord(dRecord, Handshaker.this.connection);
                            }
                        });
                        continue;
                    }
                    this.recordLayer.processRecord(deferredRecord, this.connection);
                }
            }
        }
        catch (GeneralSecurityException e) {
            this.LOGGER.warn("Cannot process handshake message from peer [{}] due to [{}]", new Object[]{this.getSession().getPeer(), e.getMessage(), e});
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer());
            throw new HandshakeException("Cannot process handshake message", alert);
        }
    }

    protected void expectMessage(DTLSMessage message) throws HandshakeException {
        if (this.useStateValidation && this.states != null) {
            HandshakeState nextExpectedState;
            if (this.statesIndex >= this.states.length) {
                this.LOGGER.warn("Cannot process {} message from peer [{}], no more expected!", (Object)HandshakeState.toString(message), (Object)this.getSession().getPeer());
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer());
                throw new HandshakeException("Cannot process " + HandshakeState.toString(message) + " handshake message, no more expected!", alert);
            }
            HandshakeState expectedState = this.states[this.statesIndex];
            boolean expected = expectedState.expect(message);
            if (!expected && expectedState.isOptional() && this.statesIndex + 1 < this.states.length && (nextExpectedState = this.states[this.statesIndex + 1]).expect(message)) {
                ++this.statesIndex;
                expected = true;
            }
            if (!expected) {
                this.LOGGER.warn("Cannot process {} message from peer [{}], {} expected!", new Object[]{HandshakeState.toString(message), this.getSession().getPeer(), expectedState});
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer());
                throw new HandshakeException("Cannot process " + HandshakeState.toString(message) + " handshake message, " + expectedState + " expected!", alert);
            }
        }
    }

    protected abstract void doProcessMessage(HandshakeMessage var1) throws HandshakeException, GeneralSecurityException;

    public abstract void startHandshake() throws HandshakeException;

    public void processAsyncPskSecretResult(PskSecretResult pskSecretResult) throws HandshakeException {
        this.processPskSecretResult(pskSecretResult);
        if (this.changeCipherSuiteMessageExpected) {
            this.processNextMessages(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPskSecretResult(PskSecretResult pskSecretResult) throws HandshakeException {
        block9: {
            if (!this.pskRequestPending) {
                throw new IllegalStateException("psk secret not pending!");
            }
            this.pskRequestPending = false;
            try {
                this.ensureUndestroyed();
                String hostName = this.sniEnabled ? this.session.getHostName() : null;
                PskPublicInformation pskIdentity = pskSecretResult.getPskPublicInformation();
                SecretKey newPskSecret = pskSecretResult.getSecret();
                if (newPskSecret != null) {
                    if (hostName != null) {
                        this.LOGGER.trace("client [{}] uses PSK identity [{}] for server [{}]", new Object[]{this.session.getPeer(), pskIdentity, hostName});
                    } else {
                        this.LOGGER.trace("client [{}] uses PSK identity [{}]", (Object)this.session.getPeer(), (Object)pskIdentity);
                    }
                    PreSharedKeyIdentity pskPrincipal = this.sniEnabled ? new PreSharedKeyIdentity(hostName, pskIdentity.getPublicInfoAsString()) : new PreSharedKeyIdentity(pskIdentity.getPublicInfoAsString());
                    this.session.setPeerIdentity((Principal)pskPrincipal);
                    if ("PSK".equals(newPskSecret.getAlgorithm())) {
                        Mac hmac = this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac();
                        SecretKey premasterSecret = PseudoRandomFunction.generatePremasterSecretFromPSK(this.otherSecret, newPskSecret);
                        SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(hmac, premasterSecret, this.generateRandomSeed());
                        SecretUtil.destroy(premasterSecret);
                        SecretUtil.destroy(newPskSecret);
                        newPskSecret = masterSecret;
                    }
                    this.customArgument = pskSecretResult.getCustomArgument();
                    this.processMasterSecret(newPskSecret);
                    break block9;
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNKNOWN_PSK_IDENTITY, this.session.getPeer());
                if (hostName != null) {
                    throw new HandshakeException(String.format("No pre-shared key found for [virtual host: %s, identity: %s]", new Object[]{hostName, pskIdentity}), alert);
                }
                throw new HandshakeException(String.format("No pre-shared key found for [identity: %s]", new Object[]{pskIdentity}), alert);
            }
            finally {
                SecretUtil.destroy(this.otherSecret);
                this.otherSecret = null;
            }
        }
    }

    protected abstract void processMasterSecret(SecretKey var1) throws HandshakeException;

    protected final MessageDigest getHandshakeMessageDigest() {
        MessageDigest md = this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMessageDigest();
        int index = 0;
        for (HandshakeMessage handshakeMessage : this.handshakeMessages) {
            md.update(handshakeMessage.toByteArray());
            this.LOGGER.trace("  [{}] - {}", (Object)index, (Object)handshakeMessage.getMessageType());
            ++index;
        }
        return md;
    }

    protected void applyMasterSecret(SecretKey masterSecret) {
        this.ensureUndestroyed();
        this.masterSecret = SecretUtil.create(masterSecret);
        this.calculateKeys(masterSecret);
        this.session.setMasterSecret(masterSecret);
    }

    protected void calculateKeys(SecretKey masterSecret) {
        this.ensureUndestroyed();
        int macKeyLength = this.session.getCipherSuite().getMacKeyLength();
        int encKeyLength = this.session.getCipherSuite().getEncKeyLength();
        int fixedIvLength = this.session.getCipherSuite().getFixedIvLength();
        int totalLength = (macKeyLength + encKeyLength + fixedIvLength) * 2;
        byte[] seed = Bytes.concatenate((Bytes)this.serverRandom, (Bytes)this.clientRandom);
        byte[] data = PseudoRandomFunction.doPRF(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), masterSecret, PseudoRandomFunction.Label.KEY_EXPANSION_LABEL, seed, totalLength);
        int index = 0;
        int length = macKeyLength;
        this.clientWriteMACKey = SecretUtil.create(data, index, length, "Mac");
        this.serverWriteMACKey = SecretUtil.create(data, index += length, length, "Mac");
        index += length;
        length = encKeyLength;
        this.clientWriteKey = SecretUtil.create(data, index, length, "AES");
        this.serverWriteKey = SecretUtil.create(data, index += length, length, "AES");
        index += length;
        length = fixedIvLength;
        this.clientWriteIV = SecretUtil.createIv(data, index, length);
        this.serverWriteIV = SecretUtil.createIv(data, index += length, length);
        Bytes.clear((byte[])data);
    }

    protected byte[] generateRandomSeed() {
        return Bytes.concatenate((Bytes)this.clientRandom, (Bytes)this.serverRandom);
    }

    protected PskSecretResult requestPskSecretResult(PskPublicInformation pskIdentity, SecretKey otherSecret) {
        ServerNames serverNames = this.sniEnabled ? this.session.getServerNames() : null;
        String hmacAlgorithm = this.session.getCipherSuite().getPseudoRandomFunctionMacName();
        this.pskRequestPending = true;
        this.otherSecret = SecretUtil.create(otherSecret);
        return this.advancedPskStore.requestPskSecretResult(this.connection.getConnectionId(), serverNames, pskIdentity, hmacAlgorithm, otherSecret, this.generateRandomSeed());
    }

    protected final void setCurrentReadState() {
        DTLSConnectionState connectionState = this.isClient ? DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey) : DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey);
        this.session.setReadState(connectionState);
    }

    protected final void setCurrentWriteState() {
        DTLSConnectionState connectionState = this.isClient ? DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey) : DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey);
        this.session.setWriteState(connectionState);
    }

    protected final void wrapMessage(DTLSFlight flight, DTLSMessage fragment) throws HandshakeException {
        try {
            switch (fragment.getContentType()) {
                case HANDSHAKE: {
                    this.wrapHandshakeMessage(flight, (HandshakeMessage)fragment);
                    break;
                }
                case CHANGE_CIPHER_SPEC: {
                    flight.addMessage(new Record(fragment.getContentType(), this.session.getWriteEpoch(), this.session.getSequenceNumber(), fragment, this.session, false, 0));
                    break;
                }
                default: {
                    throw new HandshakeException("Cannot create " + (Object)((Object)fragment.getContentType()) + " record for flight", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer()));
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw new HandshakeException("Cannot create record", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer()));
        }
    }

    private void wrapHandshakeMessage(DTLSFlight flight, HandshakeMessage handshakeMessage) throws GeneralSecurityException {
        int fragmentLength;
        this.applySendMessageSequenceNumber(handshakeMessage);
        int messageLength = handshakeMessage.getMessageLength();
        int maxFragmentLength = this.session.getMaxFragmentLength();
        if (this.session.getWriteEpoch() == 0) {
            this.handshakeMessages.add(handshakeMessage);
        }
        if (messageLength <= maxFragmentLength) {
            boolean useCid = handshakeMessage.getMessageType() == HandshakeType.FINISHED;
            flight.addMessage(new Record(ContentType.HANDSHAKE, this.session.getWriteEpoch(), this.session.getSequenceNumber(), handshakeMessage, this.session, useCid, 0));
            return;
        }
        this.LOGGER.debug("Splitting up {} message for [{}] into multiple fragments of max {} bytes", new Object[]{handshakeMessage.getMessageType(), handshakeMessage.getPeer(), maxFragmentLength});
        byte[] messageBytes = handshakeMessage.fragmentToByteArray();
        if (messageBytes.length != messageLength) {
            throw new IllegalStateException("message length " + messageLength + " differs from message " + messageBytes.length + "!");
        }
        int messageSeq = handshakeMessage.getMessageSeq();
        for (int offset = 0; offset < messageLength; offset += fragmentLength) {
            fragmentLength = maxFragmentLength;
            if (offset + fragmentLength > messageLength) {
                fragmentLength = messageLength - offset;
            }
            byte[] fragmentBytes = new byte[fragmentLength];
            System.arraycopy(messageBytes, offset, fragmentBytes, 0, fragmentLength);
            FragmentedHandshakeMessage fragmentedMessage = new FragmentedHandshakeMessage(handshakeMessage.getMessageType(), messageLength, messageSeq, offset, fragmentBytes, this.session.getPeer());
            flight.addMessage(new Record(ContentType.HANDSHAKE, this.session.getWriteEpoch(), this.session.getSequenceNumber(), fragmentedMessage, this.session, false, 0));
        }
    }

    protected final HandshakeMessage handleFragmentation(FragmentedHandshakeMessage fragment) throws HandshakeException {
        this.LOGGER.debug("Processing {} message fragment ...", (Object)fragment.getMessageType());
        if (fragment.getMessageLength() > this.maxFragmentedHandshakeMessageLength) {
            throw new HandshakeException("Fragmented message length exceeded (" + fragment.getMessageLength() + " > " + this.maxFragmentedHandshakeMessageLength + ")!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, fragment.getPeer()));
        }
        int messageSeq = fragment.getMessageSeq();
        try {
            if (this.reassembledMessage == null) {
                this.reassembledMessage = new ReassemblingHandshakeMessage(fragment);
            } else {
                if (this.reassembledMessage.getMessageSeq() != messageSeq) {
                    throw new IllegalArgumentException("Current reassemble message has different seqn " + this.reassembledMessage.getMessageSeq() + " != " + messageSeq);
                }
                this.reassembledMessage.add(fragment);
            }
            if (this.reassembledMessage.isComplete()) {
                HandshakeMessage message = HandshakeMessage.fromByteArray(this.reassembledMessage.toByteArray(), this.session.getParameter(), this.reassembledMessage.getPeer());
                this.LOGGER.debug("Successfully re-assembled {} message", (Object)message.getMessageType());
                this.reassembledMessage = null;
                return message;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new HandshakeException(ex.getMessage(), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, fragment.getPeer()));
        }
        return null;
    }

    protected final CipherSuite.KeyExchangeAlgorithm getKeyExchangeAlgorithm() {
        return this.session.getKeyExchange();
    }

    public final DTLSSession getSession() {
        return this.session;
    }

    public final InetSocketAddress getPeerAddress() {
        return this.session.getPeer();
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public Random getClientRandom() {
        return this.clientRandom;
    }

    public Random getServerRandom() {
        return this.serverRandom;
    }

    private void applySendMessageSequenceNumber(HandshakeMessage message) {
        message.setMessageSeq(this.sendMessageSequence);
        ++this.sendMessageSequence;
    }

    final int getNextReceiveMessageSequenceNumber() {
        return this.nextReceiveMessageSequence;
    }

    public void addApplicationDataForDeferredProcessing(RawData outgoingMessage) {
        if (this.deferredApplicationData.size() < this.maxDeferredProcessedOutgoingApplicationDataMessages) {
            this.deferredApplicationData.add(outgoingMessage);
        }
    }

    public void addRecordsForDeferredProcessing(Record incomingMessage) {
        if (this.addDeferredProcessedRecord(incomingMessage)) {
            this.deferredRecords.add(incomingMessage);
        }
    }

    private boolean addDeferredProcessedRecord(Record incomingMessage) {
        int size = incomingMessage.size();
        if (this.deferredRecordsSize + size < this.maxDeferredProcessedIncomingRecordsSize) {
            this.deferredRecordsSize += size;
            return true;
        }
        this.LOGGER.debug("Dropped incoming record from peer [{}], limit of {} bytes exceeded by {}+{} bytes!", new Object[]{incomingMessage.getPeerAddress(), this.maxDeferredProcessedIncomingRecordsSize, this.deferredRecordsSize, size});
        return false;
    }

    private void removeDeferredProcessedRecord(Record incomingMessage) {
        int size = incomingMessage.size();
        if (this.deferredRecordsSize < size) {
            this.LOGGER.warn("deferred processed incoming records corrupted for peer [{}]! Removing {} bytes exceeds available {} bytes!", new Object[]{incomingMessage.getPeerAddress(), size, this.deferredRecordsSize});
            throw new IllegalArgumentException("deferred processing of incoming records corrupted!");
        }
        this.deferredRecordsSize -= size;
    }

    public List<RawData> takeDeferredApplicationData() {
        ArrayList<RawData> applicationData = new ArrayList<RawData>(this.deferredApplicationData);
        this.deferredApplicationData.clear();
        return applicationData;
    }

    public List<Record> takeDeferredRecords() {
        ArrayList<Record> records = new ArrayList<Record>(this.deferredRecords);
        this.deferredRecords.clear();
        for (Record record : records) {
            this.removeDeferredProcessedRecord(record);
        }
        return records;
    }

    public void takeDeferredApplicationData(Handshaker replacedHandshaker) {
        this.deferredApplicationData.addAll(replacedHandshaker.takeDeferredApplicationData());
    }

    public void setPendingFlight(DTLSFlight pendingFlight) {
        DTLSFlight flight = this.pendingFlight.getAndSet(pendingFlight);
        if (flight != null && flight != pendingFlight) {
            flight.setResponseCompleted();
        }
    }

    public void sendLastFlight(DTLSFlight flight) {
        this.lastFlight = true;
        flight.setRetransmissionNeeded(false);
        this.sendFlight(flight);
    }

    public void sendFlight(DTLSFlight flight) {
        this.setPendingFlight(null);
        try {
            this.flightSendNanos = ClockUtil.nanoRealtime();
            this.nanosExpireTime = this.nanosExpireTimeout + this.flightSendNanos;
            this.recordLayer.sendFlight(flight, this.connection);
            this.setPendingFlight(flight);
        }
        catch (IOException e) {
            this.handshakeFailed(new Exception("handshake flight " + flight.getFlightNumber() + " failed!", e));
        }
    }

    public final void addSessionListener(SessionListener listener) {
        if (listener != null) {
            this.sessionListeners.add(listener);
        }
    }

    public final void removeSessionListener(SessionListener listener) {
        if (listener != null) {
            this.sessionListeners.remove(listener);
        }
    }

    protected final void handshakeStarted() throws HandshakeException {
        this.LOGGER.debug("handshake started {}", (Object)this.connection);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeStarted(this);
        }
    }

    protected final void sessionEstablished() throws HandshakeException {
        if (!this.sessionEstablished) {
            this.LOGGER.debug("session established {}", (Object)this.connection);
            this.amendPeerPrincipal();
            this.sessionEstablished = true;
            for (SessionListener sessionListener : this.sessionListeners) {
                sessionListener.sessionEstablished(this, this.getSession());
            }
        }
    }

    public final void handshakeCompleted() {
        this.setPendingFlight(null);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeCompleted(this);
        }
        SecretUtil.destroy(this);
        this.LOGGER.debug("handshake completed {}", (Object)this.connection);
    }

    public final void handshakeFailed(Throwable cause) {
        if (this.cause == null) {
            this.cause = cause;
        }
        if (!this.handshakeFailed && this.cause == cause) {
            this.LOGGER.debug("handshake failed {}", (Object)this.connection, (Object)cause);
            this.handshakeFailed = true;
            this.setPendingFlight(null);
            for (SessionListener sessionListener : this.sessionListeners) {
                sessionListener.handshakeFailed(this, cause);
            }
            SecretUtil.destroy(this.session);
            SecretUtil.destroy(this);
        }
    }

    public final void handshakeAborted(Throwable cause) {
        this.handshakeAborted = true;
        this.handshakeFailed(cause);
    }

    public boolean hasSessionEstablished() {
        return this.sessionEstablished;
    }

    public boolean isProbing() {
        return false;
    }

    public void resetProbing() {
    }

    public boolean isExpired() {
        return !this.sessionEstablished && this.pendingFlight.get() != null && this.nanosExpireTime < ClockUtil.nanoRealtime();
    }

    public boolean isPskRequestPending() {
        return this.pskRequestPending;
    }

    public boolean isRemovingConnection() {
        return !this.handshakeAborted && !this.connection.hasEstablishedSession();
    }

    public Throwable getFailureCause() {
        return this.cause;
    }

    public void setFailureCause(Throwable cause) {
        this.setPendingFlight(null);
        this.cause = cause;
    }

    public final void handshakeFlightRetransmitted(int flight) {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeFlightRetransmitted(this, flight);
        }
        for (RawData message : this.deferredApplicationData) {
            message.onDtlsRetransmission(flight);
        }
    }

    public final boolean isChangeCipherSpecMessageExpected() {
        return this.changeCipherSuiteMessageExpected;
    }

    protected final void expectChangeCipherSpecMessage() {
        this.changeCipherSuiteMessageExpected = true;
    }

    public void verifyCertificate(CertificateMessage message) throws HandshakeException {
        CertPath certPath = message.getCertificateChain();
        if (certPath != null) {
            if (this.certificateVerifier == null) {
                this.LOGGER.debug("Certificate validation failed: x509 could not be trusted!");
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, this.session.getPeer());
                throw new HandshakeException("Trust is not possible!", alert);
            }
            List<? extends Certificate> certificates = certPath.getCertificates();
            if (certificates.isEmpty() && this.isClient) {
                this.LOGGER.debug("Certificate validation failed: empty server certificate!");
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, this.session.getPeer());
                throw new HandshakeException("Empty server certificate!", alert);
            }
            if (this.certificateVerifier instanceof AdvancedCertificateVerifier) {
                Boolean clientUsage = this.useKeyUsageVerification ? Boolean.valueOf(!this.isClient) : null;
                this.peerCertPath = ((AdvancedCertificateVerifier)this.certificateVerifier).verifyCertificate(clientUsage, this.useTruncatedCertificatePathForVerification, message, this.session);
            } else {
                Certificate certificate;
                if (this.useKeyUsageVerification && !certificates.isEmpty() && (certificate = certificates.get(0)) instanceof X509Certificate && !CertPathUtil.canBeUsedForAuthentication((X509Certificate)((X509Certificate)certificate), (!this.isClient ? 1 : 0) != 0)) {
                    this.LOGGER.debug("Certificate validation failed: key usage doesn't match");
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, this.session.getPeer());
                    throw new HandshakeException("Key Usage doesn't match!", alert);
                }
                this.certificateVerifier.verifyCertificate(message, this.session);
                this.peerCertPath = certPath;
            }
        } else {
            RawPublicKeyIdentity rpk = new RawPublicKeyIdentity(message.getPublicKey());
            if (!this.rpkStore.isTrusted(rpk)) {
                this.LOGGER.debug("Certificate validation failed: Raw public key is not trusted");
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, this.session.getPeer());
                throw new HandshakeException("Raw public key is not trusted!", alert);
            }
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.otherSecret);
        this.otherSecret = null;
        SecretUtil.destroy(this.masterSecret);
        this.masterSecret = null;
        SecretUtil.destroy(this.clientWriteKey);
        this.clientWriteKey = null;
        SecretUtil.destroy(this.clientWriteMACKey);
        this.clientWriteMACKey = null;
        SecretUtil.destroy(this.clientWriteIV);
        this.clientWriteIV = null;
        SecretUtil.destroy(this.serverWriteKey);
        this.serverWriteKey = null;
        SecretUtil.destroy(this.serverWriteMACKey);
        this.serverWriteMACKey = null;
        SecretUtil.destroy(this.serverWriteIV);
        this.serverWriteIV = null;
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void ensureUndestroyed() {
        if (this.destroyed) {
            if (this.handshakeFailed) {
                throw new IllegalStateException("secrets destroyed after failure!", this.cause);
            }
            if (this.sessionEstablished) {
                throw new IllegalStateException("secrets destroyed after success!");
            }
            throw new IllegalStateException("secrets destroyed ???");
        }
    }

    private void amendPeerPrincipal() {
        Principal peerIdentity = this.session.getPeerIdentity();
        if (peerIdentity instanceof ExtensiblePrincipal) {
            ExtensiblePrincipal extensibleClientIdentity = (ExtensiblePrincipal)peerIdentity;
            AdditionalInfo additionalInfo = this.getAdditionalPeerInfo(peerIdentity);
            this.session.setPeerIdentity(extensibleClientIdentity.amend(additionalInfo));
        }
    }

    private AdditionalInfo getAdditionalPeerInfo(Principal peerIdentity) {
        if (this.applicationLevelInfoSupplier == null || peerIdentity == null) {
            return AdditionalInfo.empty();
        }
        if (this.applicationLevelInfoSupplier instanceof AdvancedApplicationLevelInfoSupplier) {
            return ((AdvancedApplicationLevelInfoSupplier)((Object)this.applicationLevelInfoSupplier)).getInfo(peerIdentity, this.customArgument);
        }
        return this.applicationLevelInfoSupplier.getInfo(peerIdentity);
    }

    private class InboundMessageBuffer {
        private Record changeCipherSpec = null;
        private SortedSet<Record> queue = new TreeSet<Record>(new Comparator<Record>(){

            @Override
            public int compare(Record r1, Record r2) {
                return Handshaker.compareRecords(r1, r2);
            }
        });

        private InboundMessageBuffer() {
        }

        boolean isEmpty() {
            return this.queue.isEmpty();
        }

        Record getNextRecord() {
            Record result = null;
            if (Handshaker.this.isChangeCipherSpecMessageExpected() && this.changeCipherSpec != null) {
                result = this.changeCipherSpec;
                this.changeCipherSpec = null;
            } else {
                Record record;
                int messageSeq;
                Iterator i$ = this.queue.iterator();
                while (i$.hasNext() && (messageSeq = ((HandshakeMessage)(record = (Record)i$.next()).getFragment()).getMessageSeq()) <= Handshaker.this.nextReceiveMessageSequence) {
                    this.queue.remove(record);
                    Handshaker.this.removeDeferredProcessedRecord(record);
                    if (messageSeq != Handshaker.this.nextReceiveMessageSequence) continue;
                    result = record;
                    break;
                }
            }
            return result;
        }

        Record getNextRecord(Record candidate) {
            int sessionEpoch;
            int recordEpoch = candidate.getEpoch();
            if (recordEpoch == (sessionEpoch = Handshaker.this.session.getReadEpoch())) {
                DTLSMessage fragment = candidate.getFragment();
                switch (fragment.getContentType()) {
                    case CHANGE_CIPHER_SPEC: {
                        if (Handshaker.this.isChangeCipherSpecMessageExpected()) {
                            return candidate;
                        }
                        if (this.changeCipherSpec == null) {
                            Handshaker.this.LOGGER.debug("Change Cipher Spec is not expected and therefore kept for later processing!");
                            this.changeCipherSpec = candidate;
                            return null;
                        }
                        Handshaker.this.LOGGER.debug("Change Cipher Spec is received again!");
                        return null;
                    }
                    case HANDSHAKE: {
                        HandshakeMessage handshakeMessage = (HandshakeMessage)fragment;
                        int messageSeq = handshakeMessage.getMessageSeq();
                        if (messageSeq == Handshaker.this.nextReceiveMessageSequence) {
                            return candidate;
                        }
                        if (messageSeq > Handshaker.this.nextReceiveMessageSequence) {
                            Handshaker.this.LOGGER.debug("Queued newer {} message from current epoch, message_seq [{}] > next_receive_seq [{}]", new Object[]{handshakeMessage.getMessageType(), messageSeq, Handshaker.this.nextReceiveMessageSequence});
                            if (Handshaker.this.addDeferredProcessedRecord(candidate)) {
                                this.queue.add(candidate);
                            }
                            return null;
                        }
                        Handshaker.this.LOGGER.debug("Discarding old {} message_seq [{}] < next_receive_seq [{}]", new Object[]{handshakeMessage.getMessageType(), messageSeq, Handshaker.this.nextReceiveMessageSequence});
                        return null;
                    }
                }
                Handshaker.this.LOGGER.warn("Cannot process message of type [{}], discarding...", (Object)fragment.getContentType());
                return null;
            }
            throw new IllegalArgumentException("record epoch " + recordEpoch + " doesn't match session " + sessionEpoch);
        }

        public void clean(long recordSequenceNumber) {
            if (this.changeCipherSpec != null && this.changeCipherSpec.getSequenceNumber() == recordSequenceNumber) {
                this.changeCipherSpec = null;
            }
            for (Record record : this.queue) {
                if (record.getSequenceNumber() != recordSequenceNumber) continue;
                this.queue.remove(record);
                Handshaker.this.removeDeferredProcessedRecord(record);
            }
        }
    }
}

