/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;

public class SignatureAlgorithmsExtension
extends HelloExtension {
    private static final int LIST_LENGTH_BITS = 16;
    private static final int SIGNATURE_ALGORITHM_BITS = 16;
    private static final int SIGNATURE_BITS = 8;
    private static final int HASH_BITS = 8;
    private final List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms;

    public SignatureAlgorithmsExtension(List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
        super(HelloExtension.ExtensionType.SIGNATURE_ALGORITHMS);
        this.signatureAndHashAlgorithms = signatureAndHashAlgorithms;
    }

    @Override
    protected void addExtensionData(DatagramWriter writer) {
        int listLength = this.signatureAndHashAlgorithms.size() * 2;
        writer.write(listLength + 2, 16);
        writer.write(listLength, 16);
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : this.signatureAndHashAlgorithms) {
            writer.write(signatureAndHashAlgorithm.getHash().getCode(), 8);
            writer.write(signatureAndHashAlgorithm.getSignature().getCode(), 8);
        }
    }

    public static HelloExtension fromExtensionDataReader(DatagramReader extensionDataReader) {
        ArrayList<SignatureAndHashAlgorithm> signatureAndHashAlgorithms = new ArrayList();
        int listLength = extensionDataReader.read(16);
        DatagramReader rangeReader = extensionDataReader.createRangeReader(listLength);
        while (rangeReader.bytesAvailable()) {
            int hashId = rangeReader.read(8);
            int signatureId = rangeReader.read(8);
            signatureAndHashAlgorithms.add(new SignatureAndHashAlgorithm(hashId, signatureId));
        }
        signatureAndHashAlgorithms = Collections.unmodifiableList(signatureAndHashAlgorithms);
        return new SignatureAlgorithmsExtension(signatureAndHashAlgorithms);
    }

    @Override
    public int getLength() {
        return 6 + this.signatureAndHashAlgorithms.size() * 2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\t\t\tLength: ").append(this.getLength() - 4);
        sb.append(StringUtil.lineSeparator()).append("\t\t\t\tSignature Algorithms Length: ").append(this.getLength() - 6);
        sb.append(StringUtil.lineSeparator()).append("\t\t\t\tSignature Algorithms (").append(this.signatureAndHashAlgorithms.size()).append(" algorithm):");
        for (SignatureAndHashAlgorithm signatureAndHashAlgoritm : this.signatureAndHashAlgorithms) {
            sb.append(StringUtil.lineSeparator()).append("\t\t\t\t\tSignature Algorithm: ");
            sb.append(StringUtil.lineSeparator()).append("\t\t\t\t\t\tSignature Hash Algorithm Hash: ");
            if (signatureAndHashAlgoritm.getHash() != null) {
                sb.append((Object)signatureAndHashAlgoritm.getHash());
            } else {
                sb.append("unknown");
            }
            sb.append(StringUtil.lineSeparator()).append("\t\t\t\t\t\tSignature Hash Algorithm Signature: ");
            if (signatureAndHashAlgoritm.getSignature() != null) {
                sb.append((Object)signatureAndHashAlgoritm.getSignature());
                continue;
            }
            sb.append("unknown");
        }
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }

    public List<SignatureAndHashAlgorithm> getSupportedSignatureAndHashAlgorithms() {
        return this.signatureAndHashAlgorithms;
    }
}

