/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.auth;

import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.AbstractExtensiblePrincipal;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.elements.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertPath
extends AbstractExtensiblePrincipal<X509CertPath> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)X509CertPath.class.getCanonicalName());
    private static final String TYPE_X509 = "X.509";
    private static final String ENCODING = "PkiPath";
    private final CertPath path;
    private final X509Certificate target;

    public X509CertPath(CertPath certPath) {
        this(certPath, null);
    }

    private X509CertPath(CertPath certPath, AdditionalInfo additionalInformation) {
        super(additionalInformation);
        if (!TYPE_X509.equals(certPath.getType())) {
            throw new IllegalArgumentException("Cert path must contain X.509 certificates only");
        }
        if (certPath.getCertificates().isEmpty()) {
            throw new IllegalArgumentException("Cert path must not be empty");
        }
        this.path = certPath;
        this.target = (X509Certificate)certPath.getCertificates().get(0);
    }

    @Override
    public X509CertPath amend(AdditionalInfo additionInfo) {
        return new X509CertPath(this.path, additionInfo);
    }

    public static X509CertPath fromBytes(byte[] encodedPath) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance(TYPE_X509);
            CertPath certPath = factory.generateCertPath(new ByteArrayInputStream(encodedPath), ENCODING);
            return new X509CertPath(certPath);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("byte array does not contain X.509 certificate path");
        }
    }

    public static X509CertPath fromCertificatesChain(Certificate ... certificateChain) {
        if (certificateChain != null && certificateChain.length == 0) {
            throw new IllegalArgumentException("Certificate chain must not be empty!");
        }
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        for (Certificate cert : certificateChain) {
            if (!(cert instanceof X509Certificate)) {
                throw new IllegalArgumentException("Given certificate is not X.509! " + cert);
            }
            chain.add((X509Certificate)cert);
        }
        CertPath certPath = X509CertPath.generateCertPath(true, chain);
        return new X509CertPath(certPath);
    }

    public static X509CertPath fromCertificatesChain(List<X509Certificate> certificateChain) {
        if (certificateChain != null && certificateChain.isEmpty()) {
            throw new IllegalArgumentException("Certificate chain must not be empty!");
        }
        CertPath certPath = X509CertPath.generateCertPath(true, certificateChain);
        return new X509CertPath(certPath);
    }

    public static CertPath generateCertPath(boolean includeRoot, List<X509Certificate> certificateChain) {
        if (certificateChain == null) {
            throw new NullPointerException("Certificate chain must not be null!");
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        X500Principal issuer = null;
        try {
            int index = 0;
            CertificateFactory factory = CertificateFactory.getInstance(TYPE_X509);
            for (Certificate certificate : certificateChain) {
                if (!(certificate instanceof X509Certificate)) {
                    throw new IllegalArgumentException("Given certificate is not X.509! " + certificate);
                }
                X509Certificate xcert = (X509Certificate)certificate;
                LOGGER.debug("Current Subject DN: {}", (Object)xcert.getSubjectX500Principal().getName());
                if (issuer != null && !issuer.equals(xcert.getSubjectX500Principal())) {
                    LOGGER.debug("Actual Issuer DN: {}", (Object)xcert.getSubjectX500Principal().getName());
                    throw new IllegalArgumentException("Given certificates do not form a chain");
                }
                ++index;
                if (xcert.getIssuerX500Principal().equals(xcert.getSubjectX500Principal())) {
                    if (index != certificateChain.size()) {
                        throw new IllegalArgumentException("Given certificates do not form a chain, root is not the last!");
                    }
                    if (!includeRoot && certificateChain.size() != 1) continue;
                    certificates.add(xcert);
                    continue;
                }
                certificates.add(xcert);
                issuer = xcert.getIssuerX500Principal();
                LOGGER.debug("Expected Issuer DN: {}", (Object)issuer.getName());
            }
            return factory.generateCertPath(certificates);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("could not create X.509 certificate factory", e);
        }
    }

    public byte[] toByteArray() {
        try {
            return this.path.getEncoded(ENCODING);
        }
        catch (CertificateEncodingException e) {
            return Bytes.EMPTY;
        }
    }

    @Override
    public String getName() {
        return this.target.getSubjectX500Principal().getName();
    }

    public CertPath getPath() {
        return this.path;
    }

    public X509Certificate getTarget() {
        return this.target;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509CertPath other = (X509CertPath)obj;
        return this.target.equals(other.target);
    }

    @Override
    public int hashCode() {
        return this.target.hashCode();
    }

    @Override
    public String toString() {
        return "x509 [" + this.getName() + "]";
    }
}

