/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

public class ProtocolVersion
implements Comparable<ProtocolVersion> {
    public static final int MAJOR_1_2 = 254;
    public static final int MINOR_1_2 = 253;
    public static final ProtocolVersion VERSION_DTLS_1_2 = new ProtocolVersion(254, 253);
    private final int minor;
    private final int major;

    @Deprecated
    public ProtocolVersion() {
        this.major = 254;
        this.minor = 253;
    }

    @Deprecated
    public ProtocolVersion(int major, int minor) {
        this.minor = minor;
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMajor() {
        return this.major;
    }

    @Override
    public int compareTo(ProtocolVersion o) {
        if (this == o) {
            return 0;
        }
        if (this.major == o.getMajor()) {
            if (this.minor < o.getMinor()) {
                return 1;
            }
            if (this.minor > o.getMinor()) {
                return -1;
            }
            return 0;
        }
        if (this.major < o.getMajor()) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolVersion)) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        return this.major == other.major && this.minor == other.minor;
    }

    public String toString() {
        return Integer.toString(255 - this.major) + "." + Integer.toString(255 - this.minor);
    }

    public static ProtocolVersion valueOf(int major, int minor) {
        if (major == 254 && minor == 253) {
            return VERSION_DTLS_1_2;
        }
        return new ProtocolVersion(major, minor);
    }
}

